<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardAuthorization StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the amount of money for which the the requester is seeking authorization. | Specifies credit card information about the customer seeking authorization.
 * @subpackage Structs
 */
class CreditCardAuthorization extends AbstractStructBase
{
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - documentation: Specifies the credit card information for which authorization is required.
     * @var \StructType\PaymentCardType
     */
    public $CreditCard;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Identification of an authorization party (e.g., merchant, acquirer).
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $ID;
    /**
     * The SourceType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SourceType;
    /**
     * The ExtendedPaymentInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the requester would like to apply extended payment conditions to this authorization.
     * - use: optional
     * @var bool
     */
    public $ExtendedPaymentInd;
    /**
     * The ExtendedPaymentQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of equal amount, partial payments for the extended payment. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $ExtendedPaymentQuantity;
    /**
     * The ExtendedPaymentFrequency
     * Meta information extracted from the WSDL
     * - documentation: The frequency of extended payment installments.
     * - use: optional
     * @var string
     */
    public $ExtendedPaymentFrequency;
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [A-Za-z0-9]{1,12}
     * - use: optional
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The ReversalIndicator
     * Meta information extracted from the WSDL
     * - documentation: If true, indicates a request to reverse a credit authorization.
     * - use: optional
     * @var bool
     */
    public $ReversalIndicator;
    /**
     * The CardPresentInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the customer has actually presented the credit card.
     * - use: optional
     * @var bool
     */
    public $CardPresentInd;
    /**
     * The E_CommerceCode
     * Meta information extracted from the WSDL
     * - documentation: The electronic commerce indicator required for some credit card authorizations, such as the Verified by Visa Process. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $E_CommerceCode;
    /**
     * The AuthTransactionID
     * Meta information extracted from the WSDL
     * - documentation: The authentication transaction identifier required for some credit card authorizations, such as the Verified by Visa Process. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AuthTransactionID;
    /**
     * The AuthVerificationValue
     * Meta information extracted from the WSDL
     * - documentation: The cardholder authentication verfication value required for some credit card authorization, such as the Verified by Visa Process. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AuthVerificationValue;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for CreditCardAuthorization
     * @uses CreditCardAuthorization::setCreditCard()
     * @uses CreditCardAuthorization::setID()
     * @uses CreditCardAuthorization::setSourceType()
     * @uses CreditCardAuthorization::setExtendedPaymentInd()
     * @uses CreditCardAuthorization::setExtendedPaymentQuantity()
     * @uses CreditCardAuthorization::setExtendedPaymentFrequency()
     * @uses CreditCardAuthorization::setAuthorizationCode()
     * @uses CreditCardAuthorization::setReversalIndicator()
     * @uses CreditCardAuthorization::setCardPresentInd()
     * @uses CreditCardAuthorization::setE_CommerceCode()
     * @uses CreditCardAuthorization::setAuthTransactionID()
     * @uses CreditCardAuthorization::setAuthVerificationValue()
     * @uses CreditCardAuthorization::setAmount()
     * @uses CreditCardAuthorization::setCurrencyCode()
     * @uses CreditCardAuthorization::setDecimalPlaces()
     * @param \StructType\PaymentCardType $creditCard
     * @param \StructType\UniqueID_Type[] $iD
     * @param string $sourceType
     * @param bool $extendedPaymentInd
     * @param int $extendedPaymentQuantity
     * @param string $extendedPaymentFrequency
     * @param string $authorizationCode
     * @param bool $reversalIndicator
     * @param bool $cardPresentInd
     * @param string $e_CommerceCode
     * @param string $authTransactionID
     * @param string $authVerificationValue
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(\StructType\PaymentCardType $creditCard = null, array $iD = array(), $sourceType = null, $extendedPaymentInd = null, $extendedPaymentQuantity = null, $extendedPaymentFrequency = null, $authorizationCode = null, $reversalIndicator = null, $cardPresentInd = null, $e_CommerceCode = null, $authTransactionID = null, $authVerificationValue = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setCreditCard($creditCard)
            ->setID($iD)
            ->setSourceType($sourceType)
            ->setExtendedPaymentInd($extendedPaymentInd)
            ->setExtendedPaymentQuantity($extendedPaymentQuantity)
            ->setExtendedPaymentFrequency($extendedPaymentFrequency)
            ->setAuthorizationCode($authorizationCode)
            ->setReversalIndicator($reversalIndicator)
            ->setCardPresentInd($cardPresentInd)
            ->setE_CommerceCode($e_CommerceCode)
            ->setAuthTransactionID($authTransactionID)
            ->setAuthVerificationValue($authVerificationValue)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get CreditCard value
     * @return \StructType\PaymentCardType|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param \StructType\PaymentCardType $creditCard
     * @return \StructType\CreditCardAuthorization
     */
    public function setCreditCard(\StructType\PaymentCardType $creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Get ID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * This method is responsible for validating the values passed to the setID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIDForArrayConstraintsFromSetID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditCardAuthorizationIDItem) {
            // validation for constraint: itemType
            if (!$creditCardAuthorizationIDItem instanceof \StructType\UniqueID_Type) {
                $invalidValues[] = is_object($creditCardAuthorizationIDItem) ? get_class($creditCardAuthorizationIDItem) : sprintf('%s(%s)', gettype($creditCardAuthorizationIDItem), var_export($creditCardAuthorizationIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $iD
     * @return \StructType\CreditCardAuthorization
     */
    public function setID(array $iD = array())
    {
        // validation for constraint: array
        if ('' !== ($iDArrayErrorMessage = self::validateIDForArrayConstraintsFromSetID($iD))) {
            throw new \InvalidArgumentException($iDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($iD) && count($iD) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\CreditCardAuthorization
     */
    public function addToID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ID) && count($this->ID) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ID)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get SourceType value
     * @return string|null
     */
    public function getSourceType()
    {
        return $this->SourceType;
    }
    /**
     * Set SourceType value
     * @param string $sourceType
     * @return \StructType\CreditCardAuthorization
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: string
        if (!is_null($sourceType) && !is_string($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceType, true), gettype($sourceType)), __LINE__);
        }
        $this->SourceType = $sourceType;
        return $this;
    }
    /**
     * Get ExtendedPaymentInd value
     * @return bool|null
     */
    public function getExtendedPaymentInd()
    {
        return $this->ExtendedPaymentInd;
    }
    /**
     * Set ExtendedPaymentInd value
     * @param bool $extendedPaymentInd
     * @return \StructType\CreditCardAuthorization
     */
    public function setExtendedPaymentInd($extendedPaymentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedPaymentInd) && !is_bool($extendedPaymentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extendedPaymentInd, true), gettype($extendedPaymentInd)), __LINE__);
        }
        $this->ExtendedPaymentInd = $extendedPaymentInd;
        return $this;
    }
    /**
     * Get ExtendedPaymentQuantity value
     * @return int|null
     */
    public function getExtendedPaymentQuantity()
    {
        return $this->ExtendedPaymentQuantity;
    }
    /**
     * Set ExtendedPaymentQuantity value
     * @param int $extendedPaymentQuantity
     * @return \StructType\CreditCardAuthorization
     */
    public function setExtendedPaymentQuantity($extendedPaymentQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($extendedPaymentQuantity) && !(is_int($extendedPaymentQuantity) || ctype_digit($extendedPaymentQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extendedPaymentQuantity, true), gettype($extendedPaymentQuantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($extendedPaymentQuantity) && $extendedPaymentQuantity > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($extendedPaymentQuantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($extendedPaymentQuantity) && $extendedPaymentQuantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($extendedPaymentQuantity, true)), __LINE__);
        }
        $this->ExtendedPaymentQuantity = $extendedPaymentQuantity;
        return $this;
    }
    /**
     * Get ExtendedPaymentFrequency value
     * @return string|null
     */
    public function getExtendedPaymentFrequency()
    {
        return $this->ExtendedPaymentFrequency;
    }
    /**
     * Set ExtendedPaymentFrequency value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $extendedPaymentFrequency
     * @return \StructType\CreditCardAuthorization
     */
    public function setExtendedPaymentFrequency($extendedPaymentFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($extendedPaymentFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($extendedPaymentFrequency) ? implode(', ', $extendedPaymentFrequency) : var_export($extendedPaymentFrequency, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->ExtendedPaymentFrequency = $extendedPaymentFrequency;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\CreditCardAuthorization
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Za-z0-9]{1,12})
        if (!is_null($authorizationCode) && !preg_match('/[A-Za-z0-9]{1,12}/', $authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Za-z0-9]{1,12}', var_export($authorizationCode, true)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get ReversalIndicator value
     * @return bool|null
     */
    public function getReversalIndicator()
    {
        return $this->ReversalIndicator;
    }
    /**
     * Set ReversalIndicator value
     * @param bool $reversalIndicator
     * @return \StructType\CreditCardAuthorization
     */
    public function setReversalIndicator($reversalIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($reversalIndicator) && !is_bool($reversalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reversalIndicator, true), gettype($reversalIndicator)), __LINE__);
        }
        $this->ReversalIndicator = $reversalIndicator;
        return $this;
    }
    /**
     * Get CardPresentInd value
     * @return bool|null
     */
    public function getCardPresentInd()
    {
        return $this->CardPresentInd;
    }
    /**
     * Set CardPresentInd value
     * @param bool $cardPresentInd
     * @return \StructType\CreditCardAuthorization
     */
    public function setCardPresentInd($cardPresentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($cardPresentInd) && !is_bool($cardPresentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cardPresentInd, true), gettype($cardPresentInd)), __LINE__);
        }
        $this->CardPresentInd = $cardPresentInd;
        return $this;
    }
    /**
     * Get E_CommerceCode value
     * @return string|null
     */
    public function getE_CommerceCode()
    {
        return $this->E_CommerceCode;
    }
    /**
     * Set E_CommerceCode value
     * @param string $e_CommerceCode
     * @return \StructType\CreditCardAuthorization
     */
    public function setE_CommerceCode($e_CommerceCode = null)
    {
        // validation for constraint: string
        if (!is_null($e_CommerceCode) && !is_string($e_CommerceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e_CommerceCode, true), gettype($e_CommerceCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($e_CommerceCode) && !preg_match('/[0-9a-zA-Z]{1,8}/', $e_CommerceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($e_CommerceCode, true)), __LINE__);
        }
        $this->E_CommerceCode = $e_CommerceCode;
        return $this;
    }
    /**
     * Get AuthTransactionID value
     * @return string|null
     */
    public function getAuthTransactionID()
    {
        return $this->AuthTransactionID;
    }
    /**
     * Set AuthTransactionID value
     * @param string $authTransactionID
     * @return \StructType\CreditCardAuthorization
     */
    public function setAuthTransactionID($authTransactionID = null)
    {
        // validation for constraint: string
        if (!is_null($authTransactionID) && !is_string($authTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTransactionID, true), gettype($authTransactionID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($authTransactionID) && mb_strlen($authTransactionID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($authTransactionID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($authTransactionID) && mb_strlen($authTransactionID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($authTransactionID)), __LINE__);
        }
        $this->AuthTransactionID = $authTransactionID;
        return $this;
    }
    /**
     * Get AuthVerificationValue value
     * @return string|null
     */
    public function getAuthVerificationValue()
    {
        return $this->AuthVerificationValue;
    }
    /**
     * Set AuthVerificationValue value
     * @param string $authVerificationValue
     * @return \StructType\CreditCardAuthorization
     */
    public function setAuthVerificationValue($authVerificationValue = null)
    {
        // validation for constraint: string
        if (!is_null($authVerificationValue) && !is_string($authVerificationValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authVerificationValue, true), gettype($authVerificationValue)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($authVerificationValue) && mb_strlen($authVerificationValue) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($authVerificationValue)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($authVerificationValue) && mb_strlen($authVerificationValue) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($authVerificationValue)), __LINE__);
        }
        $this->AuthVerificationValue = $authVerificationValue;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CreditCardAuthorization
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CreditCardAuthorization
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\CreditCardAuthorization
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardAuthorization
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
