<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coverage StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is used to identify one specific coverage, insuranc or waiver, and to identify any fees that may be associated with it.
 * @subpackage Structs
 */
class Coverage extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Used to describe the specific coverage type or waiver type. Refer to OpenTravel Code List Vehicle Coverage Type (VCT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The CoverageInfo
     * Meta information extracted from the WSDL
     * - documentation: General information about this specific coverage, insurance or fees.
     * - minOccurs: 0
     * @var \StructType\FormattedTextType
     */
    public $CoverageInfo;
    /**
     * The CoverageFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CoverageFees
     */
    public $CoverageFees;
    /**
     * The RequiredInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this type of coverage must be purchased. If false, it is optional.
     * - use: optional
     * @var bool
     */
    public $RequiredInd;
    /**
     * Constructor method for Coverage
     * @uses Coverage::setType()
     * @uses Coverage::setCoverageInfo()
     * @uses Coverage::setCoverageFees()
     * @uses Coverage::setRequiredInd()
     * @param string $type
     * @param \StructType\FormattedTextType $coverageInfo
     * @param \StructType\CoverageFees $coverageFees
     * @param bool $requiredInd
     */
    public function __construct($type = null, \StructType\FormattedTextType $coverageInfo = null, \StructType\CoverageFees $coverageFees = null, $requiredInd = null)
    {
        $this
            ->setType($type)
            ->setCoverageInfo($coverageInfo)
            ->setCoverageFees($coverageFees)
            ->setRequiredInd($requiredInd);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Coverage
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($type) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CoverageInfo value
     * @return \StructType\FormattedTextType|null
     */
    public function getCoverageInfo()
    {
        return $this->CoverageInfo;
    }
    /**
     * Set CoverageInfo value
     * @param \StructType\FormattedTextType $coverageInfo
     * @return \StructType\Coverage
     */
    public function setCoverageInfo(\StructType\FormattedTextType $coverageInfo = null)
    {
        $this->CoverageInfo = $coverageInfo;
        return $this;
    }
    /**
     * Get CoverageFees value
     * @return \StructType\CoverageFees|null
     */
    public function getCoverageFees()
    {
        return $this->CoverageFees;
    }
    /**
     * Set CoverageFees value
     * @param \StructType\CoverageFees $coverageFees
     * @return \StructType\Coverage
     */
    public function setCoverageFees(\StructType\CoverageFees $coverageFees = null)
    {
        $this->CoverageFees = $coverageFees;
        return $this;
    }
    /**
     * Get RequiredInd value
     * @return bool|null
     */
    public function getRequiredInd()
    {
        return $this->RequiredInd;
    }
    /**
     * Set RequiredInd value
     * @param bool $requiredInd
     * @return \StructType\Coverage
     */
    public function setRequiredInd($requiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiredInd) && !is_bool($requiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiredInd, true), gettype($requiredInd)), __LINE__);
        }
        $this->RequiredInd = $requiredInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Coverage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
