<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountCategorySummary StructType
 * Meta information extracted from the WSDL
 * - documentation: This element has count data for each count category, identified using OpenTravel Code List CNT, such as number of guests, rooms occupied, etc.
 * @subpackage Structs
 */
class CountCategorySummary extends AbstractStructBase
{
    /**
     * The SummaryCount
     * Meta information extracted from the WSDL
     * - documentation: The total count for the category in CountCategoryCode.
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $SummaryCount;
    /**
     * The CountCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: The representation of a count category such as Guests : Number of guests, RoomsOcc : Rooms occupied. Refer to OpenTravel Code List Count Category Code (CNT). | Used for codes in the OpenTravel Code tables. Possible values of this
     * pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $CountCategoryCode;
    /**
     * Constructor method for CountCategorySummary
     * @uses CountCategorySummary::setSummaryCount()
     * @uses CountCategorySummary::setCountCategoryCode()
     * @param int $summaryCount
     * @param string $countCategoryCode
     */
    public function __construct($summaryCount = null, $countCategoryCode = null)
    {
        $this
            ->setSummaryCount($summaryCount)
            ->setCountCategoryCode($countCategoryCode);
    }
    /**
     * Get SummaryCount value
     * @return int|null
     */
    public function getSummaryCount()
    {
        return $this->SummaryCount;
    }
    /**
     * Set SummaryCount value
     * @param int $summaryCount
     * @return \StructType\CountCategorySummary
     */
    public function setSummaryCount($summaryCount = null)
    {
        // validation for constraint: int
        if (!is_null($summaryCount) && !(is_int($summaryCount) || ctype_digit($summaryCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($summaryCount, true), gettype($summaryCount)), __LINE__);
        }
        $this->SummaryCount = $summaryCount;
        return $this;
    }
    /**
     * Get CountCategoryCode value
     * @return string|null
     */
    public function getCountCategoryCode()
    {
        return $this->CountCategoryCode;
    }
    /**
     * Set CountCategoryCode value
     * @param string $countCategoryCode
     * @return \StructType\CountCategorySummary
     */
    public function setCountCategoryCode($countCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countCategoryCode) && !is_string($countCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countCategoryCode, true), gettype($countCategoryCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($countCategoryCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $countCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($countCategoryCode, true)), __LINE__);
        }
        $this->CountCategoryCode = $countCategoryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CountCategorySummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
