<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contacts StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of contacts.
 * @subpackage Structs
 */
class Contacts extends AbstractStructBase
{
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - documentation: This may be used for multiple sets of contact information (e.g., sales manager, group contact, event manager).
     * - maxOccurs: 99
     * @var \StructType\ContactPersonType[]
     */
    public $Contact;
    /**
     * Constructor method for Contacts
     * @uses Contacts::setContact()
     * @param \StructType\ContactPersonType[] $contact
     */
    public function __construct(array $contact = array())
    {
        $this
            ->setContact($contact);
    }
    /**
     * Get Contact value
     * @return \StructType\ContactPersonType[]|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * This method is responsible for validating the values passed to the setContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactForArrayConstraintsFromSetContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactsContactItem) {
            // validation for constraint: itemType
            if (!$contactsContactItem instanceof \StructType\ContactPersonType) {
                $invalidValues[] = is_object($contactsContactItem) ? get_class($contactsContactItem) : sprintf('%s(%s)', gettype($contactsContactItem), var_export($contactsContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contact property can only contain items of type \StructType\ContactPersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPersonType[] $contact
     * @return \StructType\Contacts
     */
    public function setContact(array $contact = array())
    {
        // validation for constraint: array
        if ('' !== ($contactArrayErrorMessage = self::validateContactForArrayConstraintsFromSetContact($contact))) {
            throw new \InvalidArgumentException($contactArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($contact) && count($contact) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($contact)), __LINE__);
        }
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Add item to Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPersonType $item
     * @return \StructType\Contacts
     */
    public function addToContact(\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The Contact property can only contain items of type \StructType\ContactPersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Contact) && count($this->Contact) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Contact)), __LINE__);
        }
        $this->Contact[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contacts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
