<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactPersonType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates that the receiving system should assume the default value if the user specifies no overriding value or action. | Allows for control of the sharing of data between parties. | Name of an individual and appropriate contact
 * information. May be contact information for the customer or someone affiliated with the customer.
 * @subpackage Structs
 */
class ContactPersonType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - documentation: This provides name information for a person.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Information about an address that identifies a location for a specific purposes.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\AddressInfoType[]
     */
    public $Address;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Electronic email addresses, in IETF specified format.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\EmailType[]
     */
    public $Email;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: Web site address, in IETF specified format.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\URL_Type[]
     */
    public $URL;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: Identifies a company by name.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\CompanyNameType[]
     */
    public $CompanyName;
    /**
     * The EmployeeInfo
     * Meta information extracted from the WSDL
     * - documentation: Employment identification; using an employee ID number, title, level within the company, and an indication of their status, i.e.: active, retired, on leave, or terminated from employment. Additional information about an employee can
     * be entered into the element, including the name of the employee, if it differs from the person name identified as a customer or contact.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The ContactType
     * Meta information extracted from the WSDL
     * - documentation: Type of contact in the context of use for the travel experience; such as permanent, temporary, affiliation, travel arranger, etc. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ContactType;
    /**
     * The Relation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of relationship with the person or company in the profile, such as Spouse, Child, Family, Business Associate, Interest Group, Medical, Security,Other, etc. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Relation;
    /**
     * The EmergencyFlag
     * Meta information extracted from the WSDL
     * - documentation: false | Indicates if this contact should be used in the case of an emergency.
     * - use: optional
     * @var bool
     */
    public $EmergencyFlag;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Provides a unique reference to this contact person. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular
     * itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The CommunicationMethodCode
     * Meta information extracted from the WSDL
     * - documentation: Provides the preferred method of communication. Refer to OpenTravel Code list Distribution Type (DTB). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $CommunicationMethodCode;
    /**
     * The DocumentDistribMethodCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the method of distribution for the booking documentation. Refer to OpenTravel Code list Distribution Type (DTB). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $DocumentDistribMethodCode;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - documentation: false | When true, indicates a default value should be used.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $DefaultInd;
    /**
     * Constructor method for ContactPersonType
     * @uses ContactPersonType::setPersonName()
     * @uses ContactPersonType::setTelephone()
     * @uses ContactPersonType::setAddress()
     * @uses ContactPersonType::setEmail()
     * @uses ContactPersonType::setURL()
     * @uses ContactPersonType::setCompanyName()
     * @uses ContactPersonType::setEmployeeInfo()
     * @uses ContactPersonType::setContactType()
     * @uses ContactPersonType::setRelation()
     * @uses ContactPersonType::setEmergencyFlag()
     * @uses ContactPersonType::setRPH()
     * @uses ContactPersonType::setCommunicationMethodCode()
     * @uses ContactPersonType::setDocumentDistribMethodCode()
     * @uses ContactPersonType::setShareSynchInd()
     * @uses ContactPersonType::setShareMarketInd()
     * @uses ContactPersonType::setDefaultInd()
     * @param \StructType\PersonNameType $personName
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\AddressInfoType[] $address
     * @param \StructType\EmailType[] $email
     * @param \StructType\URL_Type[] $uRL
     * @param \StructType\CompanyNameType[] $companyName
     * @param \StructType\EmployeeInfoType[] $employeeInfo
     * @param string $contactType
     * @param string $relation
     * @param bool $emergencyFlag
     * @param string $rPH
     * @param string $communicationMethodCode
     * @param string $documentDistribMethodCode
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $defaultInd
     */
    public function __construct(\StructType\PersonNameType $personName = null, array $telephone = array(), array $address = array(), array $email = array(), array $uRL = array(), array $companyName = array(), array $employeeInfo = array(), $contactType = null, $relation = null, $emergencyFlag = null, $rPH = null, $communicationMethodCode = null, $documentDistribMethodCode = null, $shareSynchInd = null, $shareMarketInd = null, $defaultInd = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setAddress($address)
            ->setEmail($email)
            ->setURL($uRL)
            ->setCompanyName($companyName)
            ->setEmployeeInfo($employeeInfo)
            ->setContactType($contactType)
            ->setRelation($relation)
            ->setEmergencyFlag($emergencyFlag)
            ->setRPH($rPH)
            ->setCommunicationMethodCode($communicationMethodCode)
            ->setDocumentDistribMethodCode($documentDistribMethodCode)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDefaultInd($defaultInd);
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\PersonNameType $personName
     * @return \StructType\ContactPersonType
     */
    public function setPersonName(\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($contactPersonTypeTelephoneItem) ? get_class($contactPersonTypeTelephoneItem) : sprintf('%s(%s)', gettype($contactPersonTypeTelephoneItem), var_export($contactPersonTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\ContactPersonType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($telephone) && count($telephone) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\ContactPersonType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Telephone) && count($this->Telephone) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Telephone)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressInfoType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeAddressItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeAddressItem instanceof \StructType\AddressInfoType) {
                $invalidValues[] = is_object($contactPersonTypeAddressItem) ? get_class($contactPersonTypeAddressItem) : sprintf('%s(%s)', gettype($contactPersonTypeAddressItem), var_export($contactPersonTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\AddressInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressInfoType[] $address
     * @return \StructType\ContactPersonType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($address) && count($address) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressInfoType $item
     * @return \StructType\ContactPersonType
     */
    public function addToAddress(\StructType\AddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\AddressInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Address) && count($this->Address) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeEmailItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeEmailItem instanceof \StructType\EmailType) {
                $invalidValues[] = is_object($contactPersonTypeEmailItem) ? get_class($contactPersonTypeEmailItem) : sprintf('%s(%s)', gettype($contactPersonTypeEmailItem), var_export($contactPersonTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\EmailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType[] $email
     * @return \StructType\ContactPersonType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($email) && count($email) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType $item
     * @return \StructType\ContactPersonType
     */
    public function addToEmail(\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\EmailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Email) && count($this->Email) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Email)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \StructType\URL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeURLItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeURLItem instanceof \StructType\URL_Type) {
                $invalidValues[] = is_object($contactPersonTypeURLItem) ? get_class($contactPersonTypeURLItem) : sprintf('%s(%s)', gettype($contactPersonTypeURLItem), var_export($contactPersonTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type \StructType\URL_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \StructType\URL_Type[] $uRL
     * @return \StructType\ContactPersonType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($uRL) && count($uRL) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \StructType\URL_Type $item
     * @return \StructType\ContactPersonType
     */
    public function addToURL(\StructType\URL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\URL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type \StructType\URL_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->URL) && count($this->URL) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->URL)), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyNameType[]|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanyName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyNameForArrayConstraintsFromSetCompanyName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeCompanyNameItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeCompanyNameItem instanceof \StructType\CompanyNameType) {
                $invalidValues[] = is_object($contactPersonTypeCompanyNameItem) ? get_class($contactPersonTypeCompanyNameItem) : sprintf('%s(%s)', gettype($contactPersonTypeCompanyNameItem), var_export($contactPersonTypeCompanyNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompanyName property can only contain items of type \StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompanyName value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType[] $companyName
     * @return \StructType\ContactPersonType
     */
    public function setCompanyName(array $companyName = array())
    {
        // validation for constraint: array
        if ('' !== ($companyNameArrayErrorMessage = self::validateCompanyNameForArrayConstraintsFromSetCompanyName($companyName))) {
            throw new \InvalidArgumentException($companyNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($companyName) && count($companyName) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Add item to CompanyName value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType $item
     * @return \StructType\ContactPersonType
     */
    public function addToCompanyName(\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of type \StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->CompanyName) && count($this->CompanyName) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->CompanyName)), __LINE__);
        }
        $this->CompanyName[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersonTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$contactPersonTypeEmployeeInfoItem instanceof \StructType\EmployeeInfoType) {
                $invalidValues[] = is_object($contactPersonTypeEmployeeInfoItem) ? get_class($contactPersonTypeEmployeeInfoItem) : sprintf('%s(%s)', gettype($contactPersonTypeEmployeeInfoItem), var_export($contactPersonTypeEmployeeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployeeInfo property can only contain items of type \StructType\EmployeeInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeInfoType[] $employeeInfo
     * @return \StructType\ContactPersonType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeInfoArrayErrorMessage = self::validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo($employeeInfo))) {
            throw new \InvalidArgumentException($employeeInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($employeeInfo) && count($employeeInfo) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($employeeInfo)), __LINE__);
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeInfoType $item
     * @return \StructType\ContactPersonType
     */
    public function addToEmployeeInfo(\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of type \StructType\EmployeeInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->EmployeeInfo) && count($this->EmployeeInfo) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->EmployeeInfo)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @param string $contactType
     * @return \StructType\ContactPersonType
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: string
        if (!is_null($contactType) && !is_string($contactType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactType, true), gettype($contactType)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($contactType) && mb_strlen($contactType) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($contactType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contactType) && mb_strlen($contactType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contactType)), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get Relation value
     * @return string|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param string $relation
     * @return \StructType\ContactPersonType
     */
    public function setRelation($relation = null)
    {
        // validation for constraint: string
        if (!is_null($relation) && !is_string($relation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relation, true), gettype($relation)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($relation) && mb_strlen($relation) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($relation)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($relation) && mb_strlen($relation) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($relation)), __LINE__);
        }
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get EmergencyFlag value
     * @return bool|null
     */
    public function getEmergencyFlag()
    {
        return $this->EmergencyFlag;
    }
    /**
     * Set EmergencyFlag value
     * @param bool $emergencyFlag
     * @return \StructType\ContactPersonType
     */
    public function setEmergencyFlag($emergencyFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($emergencyFlag) && !is_bool($emergencyFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emergencyFlag, true), gettype($emergencyFlag)), __LINE__);
        }
        $this->EmergencyFlag = $emergencyFlag;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ContactPersonType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get CommunicationMethodCode value
     * @return string|null
     */
    public function getCommunicationMethodCode()
    {
        return $this->CommunicationMethodCode;
    }
    /**
     * Set CommunicationMethodCode value
     * @param string $communicationMethodCode
     * @return \StructType\ContactPersonType
     */
    public function setCommunicationMethodCode($communicationMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($communicationMethodCode) && !is_string($communicationMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationMethodCode, true), gettype($communicationMethodCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($communicationMethodCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $communicationMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($communicationMethodCode, true)), __LINE__);
        }
        $this->CommunicationMethodCode = $communicationMethodCode;
        return $this;
    }
    /**
     * Get DocumentDistribMethodCode value
     * @return string|null
     */
    public function getDocumentDistribMethodCode()
    {
        return $this->DocumentDistribMethodCode;
    }
    /**
     * Set DocumentDistribMethodCode value
     * @param string $documentDistribMethodCode
     * @return \StructType\ContactPersonType
     */
    public function setDocumentDistribMethodCode($documentDistribMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($documentDistribMethodCode) && !is_string($documentDistribMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDistribMethodCode, true), gettype($documentDistribMethodCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($documentDistribMethodCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $documentDistribMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($documentDistribMethodCode, true)), __LINE__);
        }
        $this->DocumentDistribMethodCode = $documentDistribMethodCode;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\ContactPersonType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\ContactPersonType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\ContactPersonType
     */
    public function setDefaultInd($defaultInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactPersonType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
