<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLocation StructType
 * Meta information extracted from the WSDL
 * - documentation: The preference level for the connection point - only, unacceptable, preferred. | Specifies a connection location, preference level, min connection time, and whether the location is allowed for stopping or changing.
 * @subpackage Structs
 */
class ConnectionLocation extends LocationType
{
    /**
     * The _
     * @var \StructType\LocationType
     */
    public $_;
    /**
     * The Inclusive
     * Meta information extracted from the WSDL
     * - documentation: true | When true, indicates the location is acceptable for a connection. When false the location should not be included for a connection.
     * - use: optional
     * @var bool
     */
    public $Inclusive;
    /**
     * The MinChangeTime
     * Meta information extracted from the WSDL
     * - documentation: Number of minutes between connections.
     * - use: optional
     * @var int
     */
    public $MinChangeTime;
    /**
     * The ConnectionInfo
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConnectionInfo;
    /**
     * The MultiAirportCityInd
     * Meta information extracted from the WSDL
     * - documentation: If true, other airports within this city may be considered (e.g., EWR, JFK when origin location is LGA.)
     * - use: optional
     * @var bool
     */
    public $MultiAirportCityInd;
    /**
     * The ConnectType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConnectType;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - documentation: Preferred | Used to indicate a level of preference for an associated item.
     * - type: PreferLevelType
     * - use: optional
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for ConnectionLocation
     * @uses ConnectionLocation::set_()
     * @uses ConnectionLocation::setInclusive()
     * @uses ConnectionLocation::setMinChangeTime()
     * @uses ConnectionLocation::setConnectionInfo()
     * @uses ConnectionLocation::setMultiAirportCityInd()
     * @uses ConnectionLocation::setConnectType()
     * @uses ConnectionLocation::setPreferLevel()
     * @param \StructType\LocationType $_
     * @param bool $inclusive
     * @param int $minChangeTime
     * @param string $connectionInfo
     * @param bool $multiAirportCityInd
     * @param string $connectType
     * @param string $preferLevel
     */
    public function __construct(\StructType\LocationType $_ = null, $inclusive = null, $minChangeTime = null, $connectionInfo = null, $multiAirportCityInd = null, $connectType = null, $preferLevel = null)
    {
        $this
            ->set_($_)
            ->setInclusive($inclusive)
            ->setMinChangeTime($minChangeTime)
            ->setConnectionInfo($connectionInfo)
            ->setMultiAirportCityInd($multiAirportCityInd)
            ->setConnectType($connectType)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return \StructType\LocationType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\LocationType $_
     * @return \StructType\ConnectionLocation
     */
    public function set_(\StructType\LocationType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Inclusive value
     * @return bool|null
     */
    public function getInclusive()
    {
        return $this->Inclusive;
    }
    /**
     * Set Inclusive value
     * @param bool $inclusive
     * @return \StructType\ConnectionLocation
     */
    public function setInclusive($inclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusive) && !is_bool($inclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusive, true), gettype($inclusive)), __LINE__);
        }
        $this->Inclusive = $inclusive;
        return $this;
    }
    /**
     * Get MinChangeTime value
     * @return int|null
     */
    public function getMinChangeTime()
    {
        return $this->MinChangeTime;
    }
    /**
     * Set MinChangeTime value
     * @param int $minChangeTime
     * @return \StructType\ConnectionLocation
     */
    public function setMinChangeTime($minChangeTime = null)
    {
        // validation for constraint: int
        if (!is_null($minChangeTime) && !(is_int($minChangeTime) || ctype_digit($minChangeTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minChangeTime, true), gettype($minChangeTime)), __LINE__);
        }
        $this->MinChangeTime = $minChangeTime;
        return $this;
    }
    /**
     * Get ConnectionInfo value
     * @return string|null
     */
    public function getConnectionInfo()
    {
        return $this->ConnectionInfo;
    }
    /**
     * Set ConnectionInfo value
     * @param string $connectionInfo
     * @return \StructType\ConnectionLocation
     */
    public function setConnectionInfo($connectionInfo = null)
    {
        // validation for constraint: string
        if (!is_null($connectionInfo) && !is_string($connectionInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionInfo, true), gettype($connectionInfo)), __LINE__);
        }
        $this->ConnectionInfo = $connectionInfo;
        return $this;
    }
    /**
     * Get MultiAirportCityInd value
     * @return bool|null
     */
    public function getMultiAirportCityInd()
    {
        return $this->MultiAirportCityInd;
    }
    /**
     * Set MultiAirportCityInd value
     * @param bool $multiAirportCityInd
     * @return \StructType\ConnectionLocation
     */
    public function setMultiAirportCityInd($multiAirportCityInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiAirportCityInd) && !is_bool($multiAirportCityInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiAirportCityInd, true), gettype($multiAirportCityInd)), __LINE__);
        }
        $this->MultiAirportCityInd = $multiAirportCityInd;
        return $this;
    }
    /**
     * Get ConnectType value
     * @return string|null
     */
    public function getConnectType()
    {
        return $this->ConnectType;
    }
    /**
     * Set ConnectType value
     * @param string $connectType
     * @return \StructType\ConnectionLocation
     */
    public function setConnectType($connectType = null)
    {
        // validation for constraint: string
        if (!is_null($connectType) && !is_string($connectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectType, true), gettype($connectType)), __LINE__);
        }
        $this->ConnectType = $connectType;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\ConnectionLocation
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
