<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConjunctionTicketNbr StructType
 * Meta information extracted from the WSDL
 * - documentation: Conjunction ticket number in case a conjunction ticket is exchanged. | Used for Character Strings, length 1 to 32.
 * - base: xs:string
 * - maxLength: 32
 * - minLength: 1
 * @subpackage Structs
 */
class ConjunctionTicketNbr extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The Coupons
     * Meta information extracted from the WSDL
     * - documentation: Gives the coupon numbers of the ticket, which will be taken for payment. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or
     * clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * @var string[]
     */
    public $Coupons;
    /**
     * Constructor method for ConjunctionTicketNbr
     * @uses ConjunctionTicketNbr::set_()
     * @uses ConjunctionTicketNbr::setCoupons()
     * @param string $_
     * @param string[] $coupons
     */
    public function __construct($_ = null, array $coupons = array())
    {
        $this
            ->set_($_)
            ->setCoupons($coupons);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ConjunctionTicketNbr
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($_) && mb_strlen($_) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Coupons value
     * @return string[]|null
     */
    public function getCoupons()
    {
        return $this->Coupons;
    }
    /**
     * This method is responsible for validating the values passed to the setCoupons method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoupons method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponsForArrayConstraintsFromSetCoupons(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conjunctionTicketNbrCouponsItem) {
            // validation for constraint: itemType
            if (!is_string($conjunctionTicketNbrCouponsItem)) {
                $invalidValues[] = is_object($conjunctionTicketNbrCouponsItem) ? get_class($conjunctionTicketNbrCouponsItem) : sprintf('%s(%s)', gettype($conjunctionTicketNbrCouponsItem), var_export($conjunctionTicketNbrCouponsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Coupons property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Coupons value
     * @param string[] $coupons
     * @return \StructType\ConjunctionTicketNbr
     */
    public function setCoupons(array $coupons = array())
    {
        // validation for constraint: list
        if ('' !== ($couponsArrayErrorMessage = self::validateCouponsForArrayConstraintsFromSetCoupons($coupons))) {
            throw new \InvalidArgumentException($couponsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($coupons) && !preg_match('/[0-9]{1,8}/', $coupons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($coupons, true)), __LINE__);
        }
        $this->Coupons = is_array($coupons) ? implode(' ', $coupons) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConjunctionTicketNbr
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
