<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyName StructType
 * Meta information extracted from the WSDL
 * - documentation: Company name to whom remittance should be directed.
 * @subpackage Structs
 */
class CompanyName extends CompanyNameType
{
    /**
     * The _
     * @var \StructType\CompanyNameType
     */
    public $_;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - documentation: This may be used to pass the name of the contact at the company for which the direct bill applies. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ContactName;
    /**
     * Constructor method for CompanyName
     * @uses CompanyName::set_()
     * @uses CompanyName::setContactName()
     * @param \StructType\CompanyNameType $_
     * @param string $contactName
     */
    public function __construct(\StructType\CompanyNameType $_ = null, $contactName = null)
    {
        $this
            ->set_($_)
            ->setContactName($contactName);
    }
    /**
     * Get _ value
     * @return \StructType\CompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\CompanyNameType $_
     * @return \StructType\CompanyName
     */
    public function set_(\StructType\CompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\CompanyName
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($contactName) && mb_strlen($contactName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($contactName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contactName) && mb_strlen($contactName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
