<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies a rate for paying commissions; can be a decimal value based on percentage paid for the commission plan, or a flat rate. | Allows for control of the sharing of data between parties. | Contains information about agreements
 * for commission arrangements with the business entity.
 * @subpackage Structs
 */
class CommissionInfoType extends FreeTextType
{
    /**
     * The _
     * @var \StructType\FreeTextType
     */
    public $_;
    /**
     * The CommissionPlanCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies a commission plan agreement between trading partners by plan code. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CommissionPlanCode;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for CommissionInfoType
     * @uses CommissionInfoType::set_()
     * @uses CommissionInfoType::setCommissionPlanCode()
     * @uses CommissionInfoType::setShareSynchInd()
     * @uses CommissionInfoType::setShareMarketInd()
     * @uses CommissionInfoType::setAmount()
     * @uses CommissionInfoType::setCurrencyCode()
     * @uses CommissionInfoType::setDecimalPlaces()
     * @param \StructType\FreeTextType $_
     * @param string $commissionPlanCode
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(\StructType\FreeTextType $_ = null, $commissionPlanCode = null, $shareSynchInd = null, $shareMarketInd = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->set_($_)
            ->setCommissionPlanCode($commissionPlanCode)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get _ value
     * @return \StructType\FreeTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\FreeTextType $_
     * @return \StructType\CommissionInfoType
     */
    public function set_(\StructType\FreeTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CommissionPlanCode value
     * @return string|null
     */
    public function getCommissionPlanCode()
    {
        return $this->CommissionPlanCode;
    }
    /**
     * Set CommissionPlanCode value
     * @param string $commissionPlanCode
     * @return \StructType\CommissionInfoType
     */
    public function setCommissionPlanCode($commissionPlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($commissionPlanCode) && !is_string($commissionPlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissionPlanCode, true), gettype($commissionPlanCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($commissionPlanCode) && mb_strlen($commissionPlanCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($commissionPlanCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($commissionPlanCode) && mb_strlen($commissionPlanCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($commissionPlanCode)), __LINE__);
        }
        $this->CommissionPlanCode = $commissionPlanCode;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\CommissionInfoType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\CommissionInfoType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CommissionInfoType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CommissionInfoType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\CommissionInfoType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
