<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeRef StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the location of points of interest.
 * @subpackage Structs
 */
class CodeRef extends LocationType
{
    /**
     * The _
     * @var \StructType\LocationType
     */
    public $_;
    /**
     * The VicinityCode
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the vicinity of the location. Refer to OpenTravel Codelist Vehicle Where at Facility (VWF). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $VicinityCode;
    /**
     * Constructor method for CodeRef
     * @uses CodeRef::set_()
     * @uses CodeRef::setVicinityCode()
     * @param \StructType\LocationType $_
     * @param string $vicinityCode
     */
    public function __construct(\StructType\LocationType $_ = null, $vicinityCode = null)
    {
        $this
            ->set_($_)
            ->setVicinityCode($vicinityCode);
    }
    /**
     * Get _ value
     * @return \StructType\LocationType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\LocationType $_
     * @return \StructType\CodeRef
     */
    public function set_(\StructType\LocationType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get VicinityCode value
     * @return string|null
     */
    public function getVicinityCode()
    {
        return $this->VicinityCode;
    }
    /**
     * Set VicinityCode value
     * @param string $vicinityCode
     * @return \StructType\CodeRef
     */
    public function setVicinityCode($vicinityCode = null)
    {
        // validation for constraint: string
        if (!is_null($vicinityCode) && !is_string($vicinityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vicinityCode, true), gettype($vicinityCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($vicinityCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $vicinityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($vicinityCode, true)), __LINE__);
        }
        $this->VicinityCode = $vicinityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CodeRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
