<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CitizenCountryName StructType
 * Meta information extracted from the WSDL
 * - documentation: Name of the (self-professed) country that is claimed for citizenship.
 * @subpackage Structs
 */
class CitizenCountryName extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: A 2 character country code as defined in ISO3166. | Specifies a 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - type: ISO3166
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - documentation: false | When true, indicates a default value should be used.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $DefaultInd;
    /**
     * Constructor method for CitizenCountryName
     * @uses CitizenCountryName::setCode()
     * @uses CitizenCountryName::setDefaultInd()
     * @param string $code
     * @param bool $defaultInd
     */
    public function __construct($code = null, $defaultInd = null)
    {
        $this
            ->setCode($code)
            ->setDefaultInd($defaultInd);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\CitizenCountryName
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($code) && !preg_match('/[a-zA-Z]{2}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($code, true)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\CitizenCountryName
     */
    public function setDefaultInd($defaultInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CitizenCountryName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
