<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelRuleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the amount of the cancellation charge. | Provides the cancellation amount due according to the time before the booking date that the cancellation occurs. The amount may be either an amount or a percentage (e.g. 50% within 30
 * days or $100 outside 30 days).
 * @subpackage Structs
 */
class CancelRuleType extends AbstractStructBase
{
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - documentation: The card to be charged with the cancellation fee.
     * - minOccurs: 0
     * @var \StructType\PaymentCardType
     */
    public $PaymentCard;
    /**
     * The CancelByDate
     * Meta information extracted from the WSDL
     * - documentation: The date by which a cancellation must be made in order to avoid this cancellation penalty. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $CancelByDate;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: The percentage to be applied for a cancellation. | Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: A monetary amount. | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - type: Money
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The code specifying a monetary unit. Use ISO 4217, three alpha code. | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * Meta information extracted from the WSDL
     * - documentation: Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217 standard "minor unit". Typically used when the amount provided includes the minor unit of currency without a decimal point (e.g.,
     * USD 8500 needs DecimalPlaces="2" to represent $85).
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for CancelRuleType
     * @uses CancelRuleType::setPaymentCard()
     * @uses CancelRuleType::setCancelByDate()
     * @uses CancelRuleType::setPercent()
     * @uses CancelRuleType::setType()
     * @uses CancelRuleType::setAmount()
     * @uses CancelRuleType::setCurrencyCode()
     * @uses CancelRuleType::setDecimalPlaces()
     * @param \StructType\PaymentCardType $paymentCard
     * @param string $cancelByDate
     * @param float $percent
     * @param string $type
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(\StructType\PaymentCardType $paymentCard = null, $cancelByDate = null, $percent = null, $type = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setPaymentCard($paymentCard)
            ->setCancelByDate($cancelByDate)
            ->setPercent($percent)
            ->setType($type)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get PaymentCard value
     * @return \StructType\PaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \StructType\PaymentCardType $paymentCard
     * @return \StructType\CancelRuleType
     */
    public function setPaymentCard(\StructType\PaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get CancelByDate value
     * @return string|null
     */
    public function getCancelByDate()
    {
        return $this->CancelByDate;
    }
    /**
     * This method is responsible for validating the value passed to the setCancelByDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelByDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setCancelByDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelByDateForUnionConstraintsFromSetCancelByDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set CancelByDate value
     * @param string $cancelByDate
     * @return \StructType\CancelRuleType
     */
    public function setCancelByDate($cancelByDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelByDate) && !is_string($cancelByDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelByDate, true), gettype($cancelByDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($cancelByDateUnionErrorMessage = self::validateCancelByDateForUnionConstraintsFromSetCancelByDate($cancelByDate))) {
            throw new \InvalidArgumentException($cancelByDateUnionErrorMessage, __LINE__);
        }
        $this->CancelByDate = $cancelByDate;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\CancelRuleType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($percent) && $percent > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($percent, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($percent) && $percent < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($percent, true)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CancelRuleType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CancelRuleType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CancelRuleType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\CancelRuleType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelRuleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
