<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPenaltiesType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of CancelPenalty.
 * @subpackage Structs
 */
class CancelPenaltiesType extends AbstractStructBase
{
    /**
     * The CancelPenalty
     * Meta information extracted from the WSDL
     * - documentation: Defines the cancellation penalty of the hotel facility.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelPenaltyType[]
     */
    public $CancelPenalty;
    /**
     * The CancelPolicyIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates a cancel policy exits. When false, no cancel policy exists. Typically this indicator is used when details are not being sent.
     * - use: optional
     * @var bool
     */
    public $CancelPolicyIndicator;
    /**
     * Constructor method for CancelPenaltiesType
     * @uses CancelPenaltiesType::setCancelPenalty()
     * @uses CancelPenaltiesType::setCancelPolicyIndicator()
     * @param \StructType\CancelPenaltyType[] $cancelPenalty
     * @param bool $cancelPolicyIndicator
     */
    public function __construct(array $cancelPenalty = array(), $cancelPolicyIndicator = null)
    {
        $this
            ->setCancelPenalty($cancelPenalty)
            ->setCancelPolicyIndicator($cancelPolicyIndicator);
    }
    /**
     * Get CancelPenalty value
     * @return \StructType\CancelPenaltyType[]|null
     */
    public function getCancelPenalty()
    {
        return $this->CancelPenalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelPenalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelPenalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelPenaltyForArrayConstraintsFromSetCancelPenalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelPenaltiesTypeCancelPenaltyItem) {
            // validation for constraint: itemType
            if (!$cancelPenaltiesTypeCancelPenaltyItem instanceof \StructType\CancelPenaltyType) {
                $invalidValues[] = is_object($cancelPenaltiesTypeCancelPenaltyItem) ? get_class($cancelPenaltiesTypeCancelPenaltyItem) : sprintf('%s(%s)', gettype($cancelPenaltiesTypeCancelPenaltyItem), var_export($cancelPenaltiesTypeCancelPenaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelPenalty property can only contain items of type \StructType\CancelPenaltyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelPenalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelPenaltyType[] $cancelPenalty
     * @return \StructType\CancelPenaltiesType
     */
    public function setCancelPenalty(array $cancelPenalty = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelPenaltyArrayErrorMessage = self::validateCancelPenaltyForArrayConstraintsFromSetCancelPenalty($cancelPenalty))) {
            throw new \InvalidArgumentException($cancelPenaltyArrayErrorMessage, __LINE__);
        }
        $this->CancelPenalty = $cancelPenalty;
        return $this;
    }
    /**
     * Add item to CancelPenalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelPenaltyType $item
     * @return \StructType\CancelPenaltiesType
     */
    public function addToCancelPenalty(\StructType\CancelPenaltyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelPenaltyType) {
            throw new \InvalidArgumentException(sprintf('The CancelPenalty property can only contain items of type \StructType\CancelPenaltyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelPenalty[] = $item;
        return $this;
    }
    /**
     * Get CancelPolicyIndicator value
     * @return bool|null
     */
    public function getCancelPolicyIndicator()
    {
        return $this->CancelPolicyIndicator;
    }
    /**
     * Set CancelPolicyIndicator value
     * @param bool $cancelPolicyIndicator
     * @return \StructType\CancelPenaltiesType
     */
    public function setCancelPolicyIndicator($cancelPolicyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelPolicyIndicator) && !is_bool($cancelPolicyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelPolicyIndicator, true), gettype($cancelPolicyIndicator)), __LINE__);
        }
        $this->CancelPolicyIndicator = $cancelPolicyIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPenaltiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
