<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Calculation StructType
 * Meta information extracted from the WSDL
 * - documentation: Information on how this charge was calculated, for example, a daily rate multiplied by the number of days, a percentage, etc.
 * @subpackage Structs
 */
class Calculation extends AbstractStructBase
{
    /**
     * The UnitCharge
     * Meta information extracted from the WSDL
     * - documentation: This is used in conjunction with UnitName to specify the charge per unit as defined by UnitName (e.g., if UnitCharge="100" and UnitName="day" the result is 100 dollars per day). | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $UnitCharge;
    /**
     * The UnitName
     * Meta information extracted from the WSDL
     * - documentation: The UnitName attribute provides the unit on which an item charge may be based when renting a vehicle (e.g., there may be a charge which is based upon the number of days, another charge that is based upon the number of miles, a charge
     * that is based upon the number of gallons). | The VehicleUnitNameSimpleType simple type defines a set of valid values for the units on which an item charge may be based when renting a vehicle. For example, there may be a charge which is based upon the
     * number of days, another charge that is based upon the numbers of miles, a charge that is based upon the number of gallons, etc.
     * - union: VehiclePeriodUnitNameType | VehicleFuelUnitNameType | DistanceUnitNameType
     * - use: optional
     * @var string
     */
    public $UnitName;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: This is used in conjunction with UnitName to specify the quantity of units as defined by UnitName (e.g., if Quantity="5" and UnitName="day" the result is 5 days). | Used for Numeric values, from 1 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - documentation: Provides the ability to define a particular percentage. | Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Percentage;
    /**
     * The Applicability
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Applicability;
    /**
     * The MaxQuantity
     * Meta information extracted from the WSDL
     * - documentation: This is used in conjunction with UnitName to specify the maximum quantity of units as defined by UnitName. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MaxQuantity;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - documentation: The total for a specific item in a calculation (e.g., ten day rental = one week plus three extra days; this attribute would provide the subtotal for just the three extra days. The VehChargeType can be used to show the total for the
     * ten day rental). | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Total;
    /**
     * Constructor method for Calculation
     * @uses Calculation::setUnitCharge()
     * @uses Calculation::setUnitName()
     * @uses Calculation::setQuantity()
     * @uses Calculation::setPercentage()
     * @uses Calculation::setApplicability()
     * @uses Calculation::setMaxQuantity()
     * @uses Calculation::setTotal()
     * @param float $unitCharge
     * @param string $unitName
     * @param int $quantity
     * @param float $percentage
     * @param string $applicability
     * @param int $maxQuantity
     * @param float $total
     */
    public function __construct($unitCharge = null, $unitName = null, $quantity = null, $percentage = null, $applicability = null, $maxQuantity = null, $total = null)
    {
        $this
            ->setUnitCharge($unitCharge)
            ->setUnitName($unitName)
            ->setQuantity($quantity)
            ->setPercentage($percentage)
            ->setApplicability($applicability)
            ->setMaxQuantity($maxQuantity)
            ->setTotal($total);
    }
    /**
     * Get UnitCharge value
     * @return float|null
     */
    public function getUnitCharge()
    {
        return $this->UnitCharge;
    }
    /**
     * Set UnitCharge value
     * @param float $unitCharge
     * @return \StructType\Calculation
     */
    public function setUnitCharge($unitCharge = null)
    {
        // validation for constraint: float
        if (!is_null($unitCharge) && !(is_float($unitCharge) || is_numeric($unitCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitCharge, true), gettype($unitCharge)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($unitCharge) && mb_strlen(mb_substr($unitCharge, mb_strpos($unitCharge, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($unitCharge, true), mb_strlen(mb_substr($unitCharge, mb_strpos($unitCharge, '.') + 1))), __LINE__);
        }
        $this->UnitCharge = $unitCharge;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * This method is responsible for validating the value passed to the setUnitName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitName method
     * This is a set of validation rules based on the union types associated to the property being set by the setUnitName method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitNameForUnionConstraintsFromSetUnitName($value)
    {
        $message = '';
        // validation for constraint: enumeration
        if (!\EnumType\VehiclePeriodUnitNameType::valueIsValid($value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VehiclePeriodUnitNameType', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\VehiclePeriodUnitNameType::getValidValues())), __LINE__);
        }
        // validation for constraint: enumeration
        if (!\EnumType\VehicleFuelUnitNameType::valueIsValid($value)) {
            $exception1 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VehicleFuelUnitNameType', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\VehicleFuelUnitNameType::getValidValues())), __LINE__);
        }
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnitNameType::valueIsValid($value)) {
            $exception2 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistanceUnitNameType', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\DistanceUnitNameType::getValidValues())), __LINE__);
        }
        if (isset($exception0) && isset($exception1) && isset($exception2)) {
            $message = sprintf("The value %s does not match any of the union rules: VehiclePeriodUnitNameType, VehicleFuelUnitNameType, DistanceUnitNameType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0, $exception1, $exception2])));
        }
        unset($exception0, $exception1, $exception2);
        return $message;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \StructType\Calculation
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        // validation for constraint: union(VehiclePeriodUnitNameType, VehicleFuelUnitNameType, DistanceUnitNameType)
        if ('' !== ($unitNameUnionErrorMessage = self::validateUnitNameForUnionConstraintsFromSetUnitName($unitName))) {
            throw new \InvalidArgumentException($unitNameUnionErrorMessage, __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Calculation
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($quantity) && $quantity > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($quantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($quantity) && $quantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($quantity, true)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\Calculation
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($percentage) && $percentage > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($percentage, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($percentage) && $percentage < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($percentage, true)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get Applicability value
     * @return string|null
     */
    public function getApplicability()
    {
        return $this->Applicability;
    }
    /**
     * Set Applicability value
     * @param string $applicability
     * @return \StructType\Calculation
     */
    public function setApplicability($applicability = null)
    {
        // validation for constraint: string
        if (!is_null($applicability) && !is_string($applicability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicability, true), gettype($applicability)), __LINE__);
        }
        $this->Applicability = $applicability;
        return $this;
    }
    /**
     * Get MaxQuantity value
     * @return int|null
     */
    public function getMaxQuantity()
    {
        return $this->MaxQuantity;
    }
    /**
     * Set MaxQuantity value
     * @param int $maxQuantity
     * @return \StructType\Calculation
     */
    public function setMaxQuantity($maxQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuantity) && !(is_int($maxQuantity) || ctype_digit($maxQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxQuantity, true), gettype($maxQuantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxQuantity) && $maxQuantity > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxQuantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxQuantity) && $maxQuantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxQuantity, true)), __LINE__);
        }
        $this->MaxQuantity = $maxQuantity;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \StructType\Calculation
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($total) && mb_strlen(mb_substr($total, mb_strpos($total, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($total, true), mb_strlen(mb_substr($total, mb_strpos($total, '.') + 1))), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Calculation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
