<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinPref StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines preferred cabin(s) to be used in a search. | Indicates preferred cabin(s) to be used in a search.
 * @subpackage Structs
 */
class CabinPref extends AbstractStructBase
{
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - documentation: Indicates preferred airline cabin.
     * - type: CabinType
     * @var string
     */
    public $Cabin;
    /**
     * The PreferLevel
     * @var string
     */
    public $PreferLevel;
    /**
     * The CabinSubtype
     * Meta information extracted from the WSDL
     * - documentation: Defines a specific cabin sub type within the cabin type (i.e., first, business, economy.) For example, Premium. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CabinSubtype;
    /**
     * Constructor method for CabinPref
     * @uses CabinPref::setCabin()
     * @uses CabinPref::setPreferLevel()
     * @uses CabinPref::setCabinSubtype()
     * @param string $cabin
     * @param string $preferLevel
     * @param string $cabinSubtype
     */
    public function __construct($cabin = null, $preferLevel = null, $cabinSubtype = null)
    {
        $this
            ->setCabin($cabin)
            ->setPreferLevel($preferLevel)
            ->setCabinSubtype($cabinSubtype);
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @uses \EnumType\CabinType::valueIsValid()
     * @uses \EnumType\CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabin
     * @return \StructType\CabinPref
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CabinType::valueIsValid($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CabinType', is_array($cabin) ? implode(', ', $cabin) : var_export($cabin, true), implode(', ', \EnumType\CabinType::getValidValues())), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\CabinPref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get CabinSubtype value
     * @return string|null
     */
    public function getCabinSubtype()
    {
        return $this->CabinSubtype;
    }
    /**
     * Set CabinSubtype value
     * @param string $cabinSubtype
     * @return \StructType\CabinPref
     */
    public function setCabinSubtype($cabinSubtype = null)
    {
        // validation for constraint: string
        if (!is_null($cabinSubtype) && !is_string($cabinSubtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinSubtype, true), gettype($cabinSubtype)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($cabinSubtype) && mb_strlen($cabinSubtype) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($cabinSubtype)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cabinSubtype) && mb_strlen($cabinSubtype) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cabinSubtype)), __LINE__);
        }
        $this->CabinSubtype = $cabinSubtype;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
