<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingReferenceID StructType
 * Meta information extracted from the WSDL
 * - documentation: The booking or confirmation number for which charges are being authorized. | Optional field available for use by trading partners as determined by their needs.
 * @subpackage Structs
 */
class BookingReferenceID extends UniqueID_Type
{
    /**
     * The FlightRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: This provides a list of flight segment RPHs associated with a specific Booking Reference ID. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign
     * individual passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $FlightRefNumberRPHList;
    /**
     * The IgnoreReservationInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the PNR should not be updated with the authorization information returned.
     * - use: optional
     * @var bool
     */
    public $IgnoreReservationInd;
    /**
     * Constructor method for BookingReferenceID
     * @uses BookingReferenceID::setFlightRefNumberRPHList()
     * @uses BookingReferenceID::setIgnoreReservationInd()
     * @param string[] $flightRefNumberRPHList
     * @param bool $ignoreReservationInd
     */
    public function __construct(array $flightRefNumberRPHList = array(), $ignoreReservationInd = null)
    {
        $this
            ->setFlightRefNumberRPHList($flightRefNumberRPHList)
            ->setIgnoreReservationInd($ignoreReservationInd);
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return string[]|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightRefNumberRPHList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightRefNumberRPHList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightRefNumberRPHListForArrayConstraintsFromSetFlightRefNumberRPHList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingReferenceIDFlightRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($bookingReferenceIDFlightRefNumberRPHListItem)) {
                $invalidValues[] = is_object($bookingReferenceIDFlightRefNumberRPHListItem) ? get_class($bookingReferenceIDFlightRefNumberRPHListItem) : sprintf('%s(%s)', gettype($bookingReferenceIDFlightRefNumberRPHListItem), var_export($bookingReferenceIDFlightRefNumberRPHListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightRefNumberRPHList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @param string[] $flightRefNumberRPHList
     * @return \StructType\BookingReferenceID
     */
    public function setFlightRefNumberRPHList(array $flightRefNumberRPHList = array())
    {
        // validation for constraint: list
        if ('' !== ($flightRefNumberRPHListArrayErrorMessage = self::validateFlightRefNumberRPHListForArrayConstraintsFromSetFlightRefNumberRPHList($flightRefNumberRPHList))) {
            throw new \InvalidArgumentException($flightRefNumberRPHListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($flightRefNumberRPHList) && !preg_match('/[0-9]{1,8}/', $flightRefNumberRPHList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($flightRefNumberRPHList, true)), __LINE__);
        }
        $this->FlightRefNumberRPHList = is_array($flightRefNumberRPHList) ? implode(' ', $flightRefNumberRPHList) : null;
        return $this;
    }
    /**
     * Get IgnoreReservationInd value
     * @return bool|null
     */
    public function getIgnoreReservationInd()
    {
        return $this->IgnoreReservationInd;
    }
    /**
     * Set IgnoreReservationInd value
     * @param bool $ignoreReservationInd
     * @return \StructType\BookingReferenceID
     */
    public function setIgnoreReservationInd($ignoreReservationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreReservationInd) && !is_bool($ignoreReservationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreReservationInd, true), gettype($ignoreReservationInd)), __LINE__);
        }
        $this->IgnoreReservationInd = $ignoreReservationInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingReferenceID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
