<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClassAvail StructType
 * Meta information extracted from the WSDL
 * - documentation: Booking codes available to be sold for a particular flight segment.
 * @subpackage Structs
 */
class BookingClassAvail extends AbstractStructBase
{
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: RPH refers back to Marketing Cabin Type. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary
     * items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Reservation Booking Designator (RBD) code (e.g. Y). | Used for an Alpha String, length 1 to 2 (for letter codes).
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - type: UpperCaseAlphaLength1to2
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The ResBookDesigQuantity
     * Meta information extracted from the WSDL
     * - documentation: Seat quantity available for this Reservation Booking Designator (RBD). | Used for Numeric Strings length 1 to 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - type: NumericStringLength1to3
     * - use: optional
     * @var string
     */
    public $ResBookDesigQuantity;
    /**
     * The ResBookDesigStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Res Book Designator Status Code (RBD). This provides the status (e.g. waitlist open, available, available by direct request to supplier only). | Used for codes in the OpenTravel Code tables. Possible
     * values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $ResBookDesigStatusCode;
    /**
     * Constructor method for BookingClassAvail
     * @uses BookingClassAvail::setRPH()
     * @uses BookingClassAvail::setResBookDesigCode()
     * @uses BookingClassAvail::setResBookDesigQuantity()
     * @uses BookingClassAvail::setResBookDesigStatusCode()
     * @param string $rPH
     * @param string $resBookDesigCode
     * @param string $resBookDesigQuantity
     * @param string $resBookDesigStatusCode
     */
    public function __construct($rPH = null, $resBookDesigCode = null, $resBookDesigQuantity = null, $resBookDesigStatusCode = null)
    {
        $this
            ->setRPH($rPH)
            ->setResBookDesigCode($resBookDesigCode)
            ->setResBookDesigQuantity($resBookDesigQuantity)
            ->setResBookDesigStatusCode($resBookDesigStatusCode);
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\BookingClassAvail
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\BookingClassAvail
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,2})
        if (!is_null($resBookDesigCode) && !preg_match('/[A-Z]{1,2}/', $resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,2}', var_export($resBookDesigCode, true)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get ResBookDesigQuantity value
     * @return string|null
     */
    public function getResBookDesigQuantity()
    {
        return $this->ResBookDesigQuantity;
    }
    /**
     * Set ResBookDesigQuantity value
     * @param string $resBookDesigQuantity
     * @return \StructType\BookingClassAvail
     */
    public function setResBookDesigQuantity($resBookDesigQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigQuantity) && !is_string($resBookDesigQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigQuantity, true), gettype($resBookDesigQuantity)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,3})
        if (!is_null($resBookDesigQuantity) && !preg_match('/[0-9]{1,3}/', $resBookDesigQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,3}', var_export($resBookDesigQuantity, true)), __LINE__);
        }
        $this->ResBookDesigQuantity = $resBookDesigQuantity;
        return $this;
    }
    /**
     * Get ResBookDesigStatusCode value
     * @return string|null
     */
    public function getResBookDesigStatusCode()
    {
        return $this->ResBookDesigStatusCode;
    }
    /**
     * Set ResBookDesigStatusCode value
     * @param string $resBookDesigStatusCode
     * @return \StructType\BookingClassAvail
     */
    public function setResBookDesigStatusCode($resBookDesigStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigStatusCode) && !is_string($resBookDesigStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigStatusCode, true), gettype($resBookDesigStatusCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($resBookDesigStatusCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $resBookDesigStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($resBookDesigStatusCode, true)), __LINE__);
        }
        $this->ResBookDesigStatusCode = $resBookDesigStatusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingClassAvail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
