<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BldgRoom StructType
 * Meta information extracted from the WSDL
 * - documentation: Building name, room, apartment, or suite number. | Used for Character Strings, length 0 to 64.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class BldgRoom extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The BldgNameIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, the information is a building name.
     * - use: optional
     * @var bool
     */
    public $BldgNameIndicator;
    /**
     * Constructor method for BldgRoom
     * @uses BldgRoom::set_()
     * @uses BldgRoom::setBldgNameIndicator()
     * @param string $_
     * @param bool $bldgNameIndicator
     */
    public function __construct($_ = null, $bldgNameIndicator = null)
    {
        $this
            ->set_($_)
            ->setBldgNameIndicator($bldgNameIndicator);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\BldgRoom
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($_) && mb_strlen($_) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get BldgNameIndicator value
     * @return bool|null
     */
    public function getBldgNameIndicator()
    {
        return $this->BldgNameIndicator;
    }
    /**
     * Set BldgNameIndicator value
     * @param bool $bldgNameIndicator
     * @return \StructType\BldgRoom
     */
    public function setBldgNameIndicator($bldgNameIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($bldgNameIndicator) && !is_bool($bldgNameIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bldgNameIndicator, true), gettype($bldgNameIndicator)), __LINE__);
        }
        $this->BldgNameIndicator = $bldgNameIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BldgRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
