<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestAvailableRate StructType
 * Meta information extracted from the WSDL
 * - documentation: The amount of the best available rate. This may be used in conjuction with the RatePlanCode attribute to define its rate. | The details of a best available rate.
 * @subpackage Structs
 */
class BestAvailableRate extends AbstractStructBase
{
    /**
     * The LengthOfStayTime
     * Meta information extracted from the WSDL
     * - documentation: Used in conjunction with the TimeUnit to define the length of stay.
     * - use: optional
     * @var int
     */
    public $LengthOfStayTime;
    /**
     * The LengthOfStayTimeUnit
     * Meta information extracted from the WSDL
     * - documentation: A time unit used to apply this status message to other inventory, and with more granularity than daily. Values: Year, Month, Week, Day, Hour, Minute, Second.
     * - use: optional
     * @var string
     */
    public $LengthOfStayTimeUnit;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: A string value used to specify the rate code as the best available rate. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The TaxInclusive
     * Meta information extracted from the WSDL
     * - documentation: When true indicates tax is included. When false tax is not included.
     * - use: optional
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for BestAvailableRate
     * @uses BestAvailableRate::setLengthOfStayTime()
     * @uses BestAvailableRate::setLengthOfStayTimeUnit()
     * @uses BestAvailableRate::setRatePlanCode()
     * @uses BestAvailableRate::setTaxInclusive()
     * @uses BestAvailableRate::setAmount()
     * @uses BestAvailableRate::setCurrencyCode()
     * @uses BestAvailableRate::setDecimalPlaces()
     * @param int $lengthOfStayTime
     * @param string $lengthOfStayTimeUnit
     * @param string $ratePlanCode
     * @param bool $taxInclusive
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($lengthOfStayTime = null, $lengthOfStayTimeUnit = null, $ratePlanCode = null, $taxInclusive = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setLengthOfStayTime($lengthOfStayTime)
            ->setLengthOfStayTimeUnit($lengthOfStayTimeUnit)
            ->setRatePlanCode($ratePlanCode)
            ->setTaxInclusive($taxInclusive)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get LengthOfStayTime value
     * @return int|null
     */
    public function getLengthOfStayTime()
    {
        return $this->LengthOfStayTime;
    }
    /**
     * Set LengthOfStayTime value
     * @param int $lengthOfStayTime
     * @return \StructType\BestAvailableRate
     */
    public function setLengthOfStayTime($lengthOfStayTime = null)
    {
        // validation for constraint: int
        if (!is_null($lengthOfStayTime) && !(is_int($lengthOfStayTime) || ctype_digit($lengthOfStayTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lengthOfStayTime, true), gettype($lengthOfStayTime)), __LINE__);
        }
        $this->LengthOfStayTime = $lengthOfStayTime;
        return $this;
    }
    /**
     * Get LengthOfStayTimeUnit value
     * @return string|null
     */
    public function getLengthOfStayTimeUnit()
    {
        return $this->LengthOfStayTimeUnit;
    }
    /**
     * Set LengthOfStayTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lengthOfStayTimeUnit
     * @return \StructType\BestAvailableRate
     */
    public function setLengthOfStayTimeUnit($lengthOfStayTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($lengthOfStayTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($lengthOfStayTimeUnit) ? implode(', ', $lengthOfStayTimeUnit) : var_export($lengthOfStayTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->LengthOfStayTimeUnit = $lengthOfStayTimeUnit;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\BestAvailableRate
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ratePlanCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ratePlanCode) && mb_strlen($ratePlanCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \StructType\BestAvailableRate
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\BestAvailableRate
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\BestAvailableRate
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\BestAvailableRate
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestAvailableRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
