<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicPropertyInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: An abbreviated short summary of hotel descriptive information.
 * @subpackage Structs
 */
class BasicPropertyInfoType extends AbstractStructBase
{
    /**
     * The VendorMessages
     * Meta information extracted from the WSDL
     * - documentation: A collection of VenderMessages.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorMessagesType[]
     */
    public $VendorMessages;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Public address of the hotel property.
     * - minOccurs: 0
     * @var \StructType\AddressInfoType
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The Award
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Award[]
     */
    public $Award;
    /**
     * The RelativePosition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RelativePositionType
     */
    public $RelativePosition;
    /**
     * The HotelAmenity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelAmenity[]
     */
    public $HotelAmenity;
    /**
     * The Recreation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recreation[]
     */
    public $Recreation;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Service[]
     */
    public $Service;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Policy
     */
    public $Policy;
    /**
     * The HotelSegmentCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the segment (e.g., luxury, upscale, extended stay) of the hotel. Refer to OpenTravel Codelist Segment Category Code (SEG). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101,
     * 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $HotelSegmentCategoryCode;
    /**
     * The SupplierIntegrationLevel
     * Meta information extracted from the WSDL
     * - documentation: The level of integration of a property to provide automated transaction information. The lower the number, the higher the integration (e.g., a 1 means the supplier has the highest level of integration automation).
     * - use: optional
     * @var int
     */
    public $SupplierIntegrationLevel;
    /**
     * The MaxGroupRoomQuantity
     * Meta information extracted from the WSDL
     * - documentation: Provides the maximum number of rooms that can be booked in a property for a group.
     * - use: optional
     * @var int
     */
    public $MaxGroupRoomQuantity;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The code specifying a monetary unit. Use ISO 4217, three alpha code. | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ChainCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $ChainCode;
    /**
     * The BrandCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $BrandCode;
    /**
     * The HotelCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The ChainName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $ChainName;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $BrandName;
    /**
     * The AreaID
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $AreaID;
    /**
     * Constructor method for BasicPropertyInfoType
     * @uses BasicPropertyInfoType::setVendorMessages()
     * @uses BasicPropertyInfoType::setPosition()
     * @uses BasicPropertyInfoType::setAddress()
     * @uses BasicPropertyInfoType::setContactNumbers()
     * @uses BasicPropertyInfoType::setAward()
     * @uses BasicPropertyInfoType::setRelativePosition()
     * @uses BasicPropertyInfoType::setHotelAmenity()
     * @uses BasicPropertyInfoType::setRecreation()
     * @uses BasicPropertyInfoType::setService()
     * @uses BasicPropertyInfoType::setPolicy()
     * @uses BasicPropertyInfoType::setHotelSegmentCategoryCode()
     * @uses BasicPropertyInfoType::setSupplierIntegrationLevel()
     * @uses BasicPropertyInfoType::setMaxGroupRoomQuantity()
     * @uses BasicPropertyInfoType::setCurrencyCode()
     * @uses BasicPropertyInfoType::setChainCode()
     * @uses BasicPropertyInfoType::setBrandCode()
     * @uses BasicPropertyInfoType::setHotelCode()
     * @uses BasicPropertyInfoType::setHotelCityCode()
     * @uses BasicPropertyInfoType::setHotelName()
     * @uses BasicPropertyInfoType::setHotelCodeContext()
     * @uses BasicPropertyInfoType::setChainName()
     * @uses BasicPropertyInfoType::setBrandName()
     * @uses BasicPropertyInfoType::setAreaID()
     * @param \StructType\VendorMessagesType[] $vendorMessages
     * @param \StructType\Position $position
     * @param \StructType\AddressInfoType $address
     * @param \StructType\ContactNumbers $contactNumbers
     * @param \StructType\Award[] $award
     * @param \StructType\RelativePositionType $relativePosition
     * @param \StructType\HotelAmenity[] $hotelAmenity
     * @param \StructType\Recreation[] $recreation
     * @param \StructType\Service[] $service
     * @param \StructType\Policy $policy
     * @param string $hotelSegmentCategoryCode
     * @param int $supplierIntegrationLevel
     * @param int $maxGroupRoomQuantity
     * @param string $currencyCode
     * @param string $chainCode
     * @param string $brandCode
     * @param string $hotelCode
     * @param string $hotelCityCode
     * @param string $hotelName
     * @param string $hotelCodeContext
     * @param string $chainName
     * @param string $brandName
     * @param string $areaID
     */
    public function __construct(array $vendorMessages = array(), \StructType\Position $position = null, \StructType\AddressInfoType $address = null, \StructType\ContactNumbers $contactNumbers = null, array $award = array(), \StructType\RelativePositionType $relativePosition = null, array $hotelAmenity = array(), array $recreation = array(), array $service = array(), \StructType\Policy $policy = null, $hotelSegmentCategoryCode = null, $supplierIntegrationLevel = null, $maxGroupRoomQuantity = null, $currencyCode = null, $chainCode = null, $brandCode = null, $hotelCode = null, $hotelCityCode = null, $hotelName = null, $hotelCodeContext = null, $chainName = null, $brandName = null, $areaID = null)
    {
        $this
            ->setVendorMessages($vendorMessages)
            ->setPosition($position)
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setAward($award)
            ->setRelativePosition($relativePosition)
            ->setHotelAmenity($hotelAmenity)
            ->setRecreation($recreation)
            ->setService($service)
            ->setPolicy($policy)
            ->setHotelSegmentCategoryCode($hotelSegmentCategoryCode)
            ->setSupplierIntegrationLevel($supplierIntegrationLevel)
            ->setMaxGroupRoomQuantity($maxGroupRoomQuantity)
            ->setCurrencyCode($currencyCode)
            ->setChainCode($chainCode)
            ->setBrandCode($brandCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelName($hotelName)
            ->setHotelCodeContext($hotelCodeContext)
            ->setChainName($chainName)
            ->setBrandName($brandName)
            ->setAreaID($areaID);
    }
    /**
     * Get VendorMessages value
     * @return \StructType\VendorMessagesType[]|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorMessages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorMessages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorMessagesForArrayConstraintsFromSetVendorMessages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeVendorMessagesItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeVendorMessagesItem instanceof \StructType\VendorMessagesType) {
                $invalidValues[] = is_object($basicPropertyInfoTypeVendorMessagesItem) ? get_class($basicPropertyInfoTypeVendorMessagesItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeVendorMessagesItem), var_export($basicPropertyInfoTypeVendorMessagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorMessages property can only contain items of type \StructType\VendorMessagesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorMessages value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorMessagesType[] $vendorMessages
     * @return \StructType\BasicPropertyInfoType
     */
    public function setVendorMessages(array $vendorMessages = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorMessagesArrayErrorMessage = self::validateVendorMessagesForArrayConstraintsFromSetVendorMessages($vendorMessages))) {
            throw new \InvalidArgumentException($vendorMessagesArrayErrorMessage, __LINE__);
        }
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Add item to VendorMessages value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorMessagesType $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToVendorMessages(\StructType\VendorMessagesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorMessagesType) {
            throw new \InvalidArgumentException(sprintf('The VendorMessages property can only contain items of type \StructType\VendorMessagesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VendorMessages[] = $item;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\BasicPropertyInfoType
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressInfoType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressInfoType $address
     * @return \StructType\BasicPropertyInfoType
     */
    public function setAddress(\StructType\AddressInfoType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \StructType\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \StructType\ContactNumbers $contactNumbers
     * @return \StructType\BasicPropertyInfoType
     */
    public function setContactNumbers(\StructType\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Award value
     * @return \StructType\Award[]|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * This method is responsible for validating the values passed to the setAward method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAward method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAwardForArrayConstraintsFromSetAward(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeAwardItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeAwardItem instanceof \StructType\Award) {
                $invalidValues[] = is_object($basicPropertyInfoTypeAwardItem) ? get_class($basicPropertyInfoTypeAwardItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeAwardItem), var_export($basicPropertyInfoTypeAwardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award[] $award
     * @return \StructType\BasicPropertyInfoType
     */
    public function setAward(array $award = array())
    {
        // validation for constraint: array
        if ('' !== ($awardArrayErrorMessage = self::validateAwardForArrayConstraintsFromSetAward($award))) {
            throw new \InvalidArgumentException($awardArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($award) && count($award) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($award)), __LINE__);
        }
        $this->Award = $award;
        return $this;
    }
    /**
     * Add item to Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToAward(\StructType\Award $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Award) {
            throw new \InvalidArgumentException(sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Award) && count($this->Award) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Award)), __LINE__);
        }
        $this->Award[] = $item;
        return $this;
    }
    /**
     * Get RelativePosition value
     * @return \StructType\RelativePositionType|null
     */
    public function getRelativePosition()
    {
        return $this->RelativePosition;
    }
    /**
     * Set RelativePosition value
     * @param \StructType\RelativePositionType $relativePosition
     * @return \StructType\BasicPropertyInfoType
     */
    public function setRelativePosition(\StructType\RelativePositionType $relativePosition = null)
    {
        $this->RelativePosition = $relativePosition;
        return $this;
    }
    /**
     * Get HotelAmenity value
     * @return \StructType\HotelAmenity[]|null
     */
    public function getHotelAmenity()
    {
        return $this->HotelAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelAmenityForArrayConstraintsFromSetHotelAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeHotelAmenityItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeHotelAmenityItem instanceof \StructType\HotelAmenity) {
                $invalidValues[] = is_object($basicPropertyInfoTypeHotelAmenityItem) ? get_class($basicPropertyInfoTypeHotelAmenityItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeHotelAmenityItem), var_export($basicPropertyInfoTypeHotelAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelAmenity property can only contain items of type \StructType\HotelAmenity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelAmenity[] $hotelAmenity
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelAmenity(array $hotelAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelAmenityArrayErrorMessage = self::validateHotelAmenityForArrayConstraintsFromSetHotelAmenity($hotelAmenity))) {
            throw new \InvalidArgumentException($hotelAmenityArrayErrorMessage, __LINE__);
        }
        $this->HotelAmenity = $hotelAmenity;
        return $this;
    }
    /**
     * Add item to HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelAmenity $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToHotelAmenity(\StructType\HotelAmenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelAmenity) {
            throw new \InvalidArgumentException(sprintf('The HotelAmenity property can only contain items of type \StructType\HotelAmenity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelAmenity[] = $item;
        return $this;
    }
    /**
     * Get Recreation value
     * @return \StructType\Recreation[]|null
     */
    public function getRecreation()
    {
        return $this->Recreation;
    }
    /**
     * This method is responsible for validating the values passed to the setRecreation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecreation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecreationForArrayConstraintsFromSetRecreation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeRecreationItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeRecreationItem instanceof \StructType\Recreation) {
                $invalidValues[] = is_object($basicPropertyInfoTypeRecreationItem) ? get_class($basicPropertyInfoTypeRecreationItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeRecreationItem), var_export($basicPropertyInfoTypeRecreationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recreation property can only contain items of type \StructType\Recreation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recreation value
     * @throws \InvalidArgumentException
     * @param \StructType\Recreation[] $recreation
     * @return \StructType\BasicPropertyInfoType
     */
    public function setRecreation(array $recreation = array())
    {
        // validation for constraint: array
        if ('' !== ($recreationArrayErrorMessage = self::validateRecreationForArrayConstraintsFromSetRecreation($recreation))) {
            throw new \InvalidArgumentException($recreationArrayErrorMessage, __LINE__);
        }
        $this->Recreation = $recreation;
        return $this;
    }
    /**
     * Add item to Recreation value
     * @throws \InvalidArgumentException
     * @param \StructType\Recreation $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToRecreation(\StructType\Recreation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recreation) {
            throw new \InvalidArgumentException(sprintf('The Recreation property can only contain items of type \StructType\Recreation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recreation[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\Service[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicPropertyInfoTypeServiceItem) {
            // validation for constraint: itemType
            if (!$basicPropertyInfoTypeServiceItem instanceof \StructType\Service) {
                $invalidValues[] = is_object($basicPropertyInfoTypeServiceItem) ? get_class($basicPropertyInfoTypeServiceItem) : sprintf('%s(%s)', gettype($basicPropertyInfoTypeServiceItem), var_export($basicPropertyInfoTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service[] $service
     * @return \StructType\BasicPropertyInfoType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\Service $item
     * @return \StructType\BasicPropertyInfoType
     */
    public function addToService(\StructType\Service $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Service) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\Service, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * Set Policy value
     * @param \StructType\Policy $policy
     * @return \StructType\BasicPropertyInfoType
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Get HotelSegmentCategoryCode value
     * @return string|null
     */
    public function getHotelSegmentCategoryCode()
    {
        return $this->HotelSegmentCategoryCode;
    }
    /**
     * Set HotelSegmentCategoryCode value
     * @param string $hotelSegmentCategoryCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelSegmentCategoryCode($hotelSegmentCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelSegmentCategoryCode) && !is_string($hotelSegmentCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelSegmentCategoryCode, true), gettype($hotelSegmentCategoryCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($hotelSegmentCategoryCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $hotelSegmentCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($hotelSegmentCategoryCode, true)), __LINE__);
        }
        $this->HotelSegmentCategoryCode = $hotelSegmentCategoryCode;
        return $this;
    }
    /**
     * Get SupplierIntegrationLevel value
     * @return int|null
     */
    public function getSupplierIntegrationLevel()
    {
        return $this->SupplierIntegrationLevel;
    }
    /**
     * Set SupplierIntegrationLevel value
     * @param int $supplierIntegrationLevel
     * @return \StructType\BasicPropertyInfoType
     */
    public function setSupplierIntegrationLevel($supplierIntegrationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($supplierIntegrationLevel) && !(is_int($supplierIntegrationLevel) || ctype_digit($supplierIntegrationLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplierIntegrationLevel, true), gettype($supplierIntegrationLevel)), __LINE__);
        }
        $this->SupplierIntegrationLevel = $supplierIntegrationLevel;
        return $this;
    }
    /**
     * Get MaxGroupRoomQuantity value
     * @return int|null
     */
    public function getMaxGroupRoomQuantity()
    {
        return $this->MaxGroupRoomQuantity;
    }
    /**
     * Set MaxGroupRoomQuantity value
     * @param int $maxGroupRoomQuantity
     * @return \StructType\BasicPropertyInfoType
     */
    public function setMaxGroupRoomQuantity($maxGroupRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxGroupRoomQuantity) && !(is_int($maxGroupRoomQuantity) || ctype_digit($maxGroupRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxGroupRoomQuantity, true), gettype($maxGroupRoomQuantity)), __LINE__);
        }
        $this->MaxGroupRoomQuantity = $maxGroupRoomQuantity;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($chainCode) && mb_strlen($chainCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($chainCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chainCode) && mb_strlen($chainCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($brandCode) && mb_strlen($brandCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($brandCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($brandCode) && mb_strlen($brandCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($hotelCode) && mb_strlen($hotelCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($hotelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCode) && mb_strlen($hotelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCityCode) && !is_string($hotelCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCityCode, true), gettype($hotelCityCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($hotelCityCode) && mb_strlen($hotelCityCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($hotelCityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCityCode) && mb_strlen($hotelCityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCityCode)), __LINE__);
        }
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($hotelName) && mb_strlen($hotelName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($hotelName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelName) && mb_strlen($hotelName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \StructType\BasicPropertyInfoType
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeContext, true), gettype($hotelCodeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($hotelCodeContext) && mb_strlen($hotelCodeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($hotelCodeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hotelCodeContext) && mb_strlen($hotelCodeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get ChainName value
     * @return string|null
     */
    public function getChainName()
    {
        return $this->ChainName;
    }
    /**
     * Set ChainName value
     * @param string $chainName
     * @return \StructType\BasicPropertyInfoType
     */
    public function setChainName($chainName = null)
    {
        // validation for constraint: string
        if (!is_null($chainName) && !is_string($chainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainName, true), gettype($chainName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($chainName) && mb_strlen($chainName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($chainName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chainName) && mb_strlen($chainName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chainName)), __LINE__);
        }
        $this->ChainName = $chainName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\BasicPropertyInfoType
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandName, true), gettype($brandName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($brandName) && mb_strlen($brandName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($brandName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($brandName) && mb_strlen($brandName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \StructType\BasicPropertyInfoType
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($areaID) && !preg_match('/[0-9]{1,8}/', $areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($areaID, true)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BasicPropertyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
