<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseByGuestAmt StructType
 * Meta information extracted from the WSDL
 * - documentation: Base charge for a given number of guests for a given age qualifying code.
 * @subpackage Structs
 */
class BaseByGuestAmt extends TotalType
{
    /**
     * The NumberOfGuestsDescription
     * Meta information extracted from the WSDL
     * - documentation: Description of number of guests and the associated age group (ex 2 Adults).
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $NumberOfGuestsDescription;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The code associated with this base charge. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $Code;
    /**
     * The NumberOfGuests
     * Meta information extracted from the WSDL
     * - documentation: The number of guests associated with this base charge. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $NumberOfGuests;
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: Defines an age range or age category of a guest (e.g., under 21, over 65, teen, infant). Refer to OpenTravel Code List Age Qualifying Code (AQC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1,
     * 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * Meta information extracted from the WSDL
     * - documentation: MinAge: The minimum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * Meta information extracted from the WSDL
     * - documentation: Max Age: The maximum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * Meta information extracted from the WSDL
     * - documentation: TimeUnit : Qualifier for Age.
     * - type: TimeUnitType
     * - use: optional
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * Constructor method for BaseByGuestAmt
     * @uses BaseByGuestAmt::setNumberOfGuestsDescription()
     * @uses BaseByGuestAmt::setCode()
     * @uses BaseByGuestAmt::setNumberOfGuests()
     * @uses BaseByGuestAmt::setAgeQualifyingCode()
     * @uses BaseByGuestAmt::setMinAge()
     * @uses BaseByGuestAmt::setMaxAge()
     * @uses BaseByGuestAmt::setAgeTimeUnit()
     * @param \StructType\ParagraphType[] $numberOfGuestsDescription
     * @param string $code
     * @param int $numberOfGuests
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     */
    public function __construct(array $numberOfGuestsDescription = array(), $code = null, $numberOfGuests = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null)
    {
        $this
            ->setNumberOfGuestsDescription($numberOfGuestsDescription)
            ->setCode($code)
            ->setNumberOfGuests($numberOfGuests)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit);
    }
    /**
     * Get NumberOfGuestsDescription value
     * @return \StructType\ParagraphType[]|null
     */
    public function getNumberOfGuestsDescription()
    {
        return $this->NumberOfGuestsDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setNumberOfGuestsDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumberOfGuestsDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumberOfGuestsDescriptionForArrayConstraintsFromSetNumberOfGuestsDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baseByGuestAmtNumberOfGuestsDescriptionItem) {
            // validation for constraint: itemType
            if (!$baseByGuestAmtNumberOfGuestsDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($baseByGuestAmtNumberOfGuestsDescriptionItem) ? get_class($baseByGuestAmtNumberOfGuestsDescriptionItem) : sprintf('%s(%s)', gettype($baseByGuestAmtNumberOfGuestsDescriptionItem), var_export($baseByGuestAmtNumberOfGuestsDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NumberOfGuestsDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NumberOfGuestsDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $numberOfGuestsDescription
     * @return \StructType\BaseByGuestAmt
     */
    public function setNumberOfGuestsDescription(array $numberOfGuestsDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($numberOfGuestsDescriptionArrayErrorMessage = self::validateNumberOfGuestsDescriptionForArrayConstraintsFromSetNumberOfGuestsDescription($numberOfGuestsDescription))) {
            throw new \InvalidArgumentException($numberOfGuestsDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($numberOfGuestsDescription) && count($numberOfGuestsDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($numberOfGuestsDescription)), __LINE__);
        }
        $this->NumberOfGuestsDescription = $numberOfGuestsDescription;
        return $this;
    }
    /**
     * Add item to NumberOfGuestsDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\BaseByGuestAmt
     */
    public function addToNumberOfGuestsDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The NumberOfGuestsDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->NumberOfGuestsDescription) && count($this->NumberOfGuestsDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->NumberOfGuestsDescription)), __LINE__);
        }
        $this->NumberOfGuestsDescription[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\BaseByGuestAmt
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($code) && mb_strlen($code) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get NumberOfGuests value
     * @return int|null
     */
    public function getNumberOfGuests()
    {
        return $this->NumberOfGuests;
    }
    /**
     * Set NumberOfGuests value
     * @param int $numberOfGuests
     * @return \StructType\BaseByGuestAmt
     */
    public function setNumberOfGuests($numberOfGuests = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGuests) && !(is_int($numberOfGuests) || ctype_digit($numberOfGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGuests, true), gettype($numberOfGuests)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($numberOfGuests) && $numberOfGuests > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($numberOfGuests, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($numberOfGuests) && $numberOfGuests < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($numberOfGuests, true)), __LINE__);
        }
        $this->NumberOfGuests = $numberOfGuests;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\BaseByGuestAmt
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ageQualifyingCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ageQualifyingCode, true)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\BaseByGuestAmt
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($minAge) && $minAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($minAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($minAge) && $minAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($minAge, true)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\BaseByGuestAmt
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxAge) && $maxAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxAge) && $maxAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxAge, true)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \StructType\BaseByGuestAmt
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseByGuestAmt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
