<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailStatusMessageType StructType
 * @subpackage Structs
 */
class AvailStatusMessageType extends AbstractStructBase
{
    /**
     * The StatusApplicationControl
     * Meta information extracted from the WSDL
     * - documentation: Information on what the AvailStatus Message applies to (i.e. the combination of inventory and rate codes) and the period of application.
     * - minOccurs: 0
     * @var \StructType\StatusApplicationControlType
     */
    public $StatusApplicationControl;
    /**
     * The LengthsOfStay
     * Meta information extracted from the WSDL
     * - documentation: Collection of Length of Stay elements. These LOS elements indicate what LOS restrictions are to be added or removed. Some systems include this information directly with the Availability Status as opposed to the booking restriction.
     * - minOccurs: 0
     * @var \StructType\LengthsOfStayType
     */
    public $LengthsOfStay;
    /**
     * The BestAvailableRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BestAvailableRates
     */
    public $BestAvailableRates;
    /**
     * The HurdleRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HurdleRate
     */
    public $HurdleRate;
    /**
     * The Delta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Delta
     */
    public $Delta;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier element allows the trading partners to uniquely identify each AvailStatusMessage, for tracing of transactions.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The RestrictionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RestrictionStatus
     */
    public $RestrictionStatus;
    /**
     * The Override
     * Meta information extracted from the WSDL
     * - documentation: Mechanism to allow the user to override settings at the reservation system and to allow the RMS to replace this overridden values: If value = "false", the reservations system may ignore the settings passed and keep values overridden
     * by the user. If value = "true", the reservations system must replace values overridden by the user.
     * - use: optional
     * @var bool
     */
    public $Override;
    /**
     * The BookingLimitMessageType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BookingLimitMessageType;
    /**
     * The BookingLimit
     * Meta information extracted from the WSDL
     * - documentation: Number of units of inventory that can be sold.
     * - use: optional
     * @var int
     */
    public $BookingLimit;
    /**
     * The LocatorID
     * Meta information extracted from the WSDL
     * - documentation: Can be used to communicate back to the sender exactly which transaction may have had a problem (e.g. "Message 214 had an invalid date range").
     * - use: optional
     * @var int
     */
    public $LocatorID;
    /**
     * The BookingThreshold
     * Meta information extracted from the WSDL
     * - documentation: Number of units down to which inventory can be sold.
     * - use: optional
     * @var int
     */
    public $BookingThreshold;
    /**
     * Constructor method for AvailStatusMessageType
     * @uses AvailStatusMessageType::setStatusApplicationControl()
     * @uses AvailStatusMessageType::setLengthsOfStay()
     * @uses AvailStatusMessageType::setBestAvailableRates()
     * @uses AvailStatusMessageType::setHurdleRate()
     * @uses AvailStatusMessageType::setDelta()
     * @uses AvailStatusMessageType::setUniqueID()
     * @uses AvailStatusMessageType::setRestrictionStatus()
     * @uses AvailStatusMessageType::setOverride()
     * @uses AvailStatusMessageType::setBookingLimitMessageType()
     * @uses AvailStatusMessageType::setBookingLimit()
     * @uses AvailStatusMessageType::setLocatorID()
     * @uses AvailStatusMessageType::setBookingThreshold()
     * @param \StructType\StatusApplicationControlType $statusApplicationControl
     * @param \StructType\LengthsOfStayType $lengthsOfStay
     * @param \StructType\BestAvailableRates $bestAvailableRates
     * @param \StructType\HurdleRate $hurdleRate
     * @param \StructType\Delta $delta
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\RestrictionStatus $restrictionStatus
     * @param bool $override
     * @param string $bookingLimitMessageType
     * @param int $bookingLimit
     * @param int $locatorID
     * @param int $bookingThreshold
     */
    public function __construct(\StructType\StatusApplicationControlType $statusApplicationControl = null, \StructType\LengthsOfStayType $lengthsOfStay = null, \StructType\BestAvailableRates $bestAvailableRates = null, \StructType\HurdleRate $hurdleRate = null, \StructType\Delta $delta = null, \StructType\UniqueID_Type $uniqueID = null, \StructType\RestrictionStatus $restrictionStatus = null, $override = null, $bookingLimitMessageType = null, $bookingLimit = null, $locatorID = null, $bookingThreshold = null)
    {
        $this
            ->setStatusApplicationControl($statusApplicationControl)
            ->setLengthsOfStay($lengthsOfStay)
            ->setBestAvailableRates($bestAvailableRates)
            ->setHurdleRate($hurdleRate)
            ->setDelta($delta)
            ->setUniqueID($uniqueID)
            ->setRestrictionStatus($restrictionStatus)
            ->setOverride($override)
            ->setBookingLimitMessageType($bookingLimitMessageType)
            ->setBookingLimit($bookingLimit)
            ->setLocatorID($locatorID)
            ->setBookingThreshold($bookingThreshold);
    }
    /**
     * Get StatusApplicationControl value
     * @return \StructType\StatusApplicationControlType|null
     */
    public function getStatusApplicationControl()
    {
        return $this->StatusApplicationControl;
    }
    /**
     * Set StatusApplicationControl value
     * @param \StructType\StatusApplicationControlType $statusApplicationControl
     * @return \StructType\AvailStatusMessageType
     */
    public function setStatusApplicationControl(\StructType\StatusApplicationControlType $statusApplicationControl = null)
    {
        $this->StatusApplicationControl = $statusApplicationControl;
        return $this;
    }
    /**
     * Get LengthsOfStay value
     * @return \StructType\LengthsOfStayType|null
     */
    public function getLengthsOfStay()
    {
        return $this->LengthsOfStay;
    }
    /**
     * Set LengthsOfStay value
     * @param \StructType\LengthsOfStayType $lengthsOfStay
     * @return \StructType\AvailStatusMessageType
     */
    public function setLengthsOfStay(\StructType\LengthsOfStayType $lengthsOfStay = null)
    {
        $this->LengthsOfStay = $lengthsOfStay;
        return $this;
    }
    /**
     * Get BestAvailableRates value
     * @return \StructType\BestAvailableRates|null
     */
    public function getBestAvailableRates()
    {
        return $this->BestAvailableRates;
    }
    /**
     * Set BestAvailableRates value
     * @param \StructType\BestAvailableRates $bestAvailableRates
     * @return \StructType\AvailStatusMessageType
     */
    public function setBestAvailableRates(\StructType\BestAvailableRates $bestAvailableRates = null)
    {
        $this->BestAvailableRates = $bestAvailableRates;
        return $this;
    }
    /**
     * Get HurdleRate value
     * @return \StructType\HurdleRate|null
     */
    public function getHurdleRate()
    {
        return $this->HurdleRate;
    }
    /**
     * Set HurdleRate value
     * @param \StructType\HurdleRate $hurdleRate
     * @return \StructType\AvailStatusMessageType
     */
    public function setHurdleRate(\StructType\HurdleRate $hurdleRate = null)
    {
        $this->HurdleRate = $hurdleRate;
        return $this;
    }
    /**
     * Get Delta value
     * @return \StructType\Delta|null
     */
    public function getDelta()
    {
        return $this->Delta;
    }
    /**
     * Set Delta value
     * @param \StructType\Delta $delta
     * @return \StructType\AvailStatusMessageType
     */
    public function setDelta(\StructType\Delta $delta = null)
    {
        $this->Delta = $delta;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\AvailStatusMessageType
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get RestrictionStatus value
     * @return \StructType\RestrictionStatus|null
     */
    public function getRestrictionStatus()
    {
        return $this->RestrictionStatus;
    }
    /**
     * Set RestrictionStatus value
     * @param \StructType\RestrictionStatus $restrictionStatus
     * @return \StructType\AvailStatusMessageType
     */
    public function setRestrictionStatus(\StructType\RestrictionStatus $restrictionStatus = null)
    {
        $this->RestrictionStatus = $restrictionStatus;
        return $this;
    }
    /**
     * Get Override value
     * @return bool|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @param bool $override
     * @return \StructType\AvailStatusMessageType
     */
    public function setOverride($override = null)
    {
        // validation for constraint: boolean
        if (!is_null($override) && !is_bool($override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($override, true), gettype($override)), __LINE__);
        }
        $this->Override = $override;
        return $this;
    }
    /**
     * Get BookingLimitMessageType value
     * @return string|null
     */
    public function getBookingLimitMessageType()
    {
        return $this->BookingLimitMessageType;
    }
    /**
     * Set BookingLimitMessageType value
     * @param string $bookingLimitMessageType
     * @return \StructType\AvailStatusMessageType
     */
    public function setBookingLimitMessageType($bookingLimitMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($bookingLimitMessageType) && !is_string($bookingLimitMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingLimitMessageType, true), gettype($bookingLimitMessageType)), __LINE__);
        }
        $this->BookingLimitMessageType = $bookingLimitMessageType;
        return $this;
    }
    /**
     * Get BookingLimit value
     * @return int|null
     */
    public function getBookingLimit()
    {
        return $this->BookingLimit;
    }
    /**
     * Set BookingLimit value
     * @param int $bookingLimit
     * @return \StructType\AvailStatusMessageType
     */
    public function setBookingLimit($bookingLimit = null)
    {
        // validation for constraint: int
        if (!is_null($bookingLimit) && !(is_int($bookingLimit) || ctype_digit($bookingLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingLimit, true), gettype($bookingLimit)), __LINE__);
        }
        $this->BookingLimit = $bookingLimit;
        return $this;
    }
    /**
     * Get LocatorID value
     * @return int|null
     */
    public function getLocatorID()
    {
        return $this->LocatorID;
    }
    /**
     * Set LocatorID value
     * @param int $locatorID
     * @return \StructType\AvailStatusMessageType
     */
    public function setLocatorID($locatorID = null)
    {
        // validation for constraint: int
        if (!is_null($locatorID) && !(is_int($locatorID) || ctype_digit($locatorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($locatorID, true), gettype($locatorID)), __LINE__);
        }
        $this->LocatorID = $locatorID;
        return $this;
    }
    /**
     * Get BookingThreshold value
     * @return int|null
     */
    public function getBookingThreshold()
    {
        return $this->BookingThreshold;
    }
    /**
     * Set BookingThreshold value
     * @param int $bookingThreshold
     * @return \StructType\AvailStatusMessageType
     */
    public function setBookingThreshold($bookingThreshold = null)
    {
        // validation for constraint: int
        if (!is_null($bookingThreshold) && !(is_int($bookingThreshold) || ctype_digit($bookingThreshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingThreshold, true), gettype($bookingThreshold)), __LINE__);
        }
        $this->BookingThreshold = $bookingThreshold;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailStatusMessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
