<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Amenity StructType
 * Meta information extracted from the WSDL
 * - documentation: This provides an area to pass amenity information. | Amenity Code Attribute is used to hold actual amenity code.
 * @subpackage Structs
 */
class Amenity extends RoomAmenityPrefType
{
    /**
     * The AmenityCode
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Room Amenity Type (RMA). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $AmenityCode;
    /**
     * The _
     * @var \StructType\RoomAmenityPrefType
     */
    public $_;
    /**
     * The PropertyAmenityType
     * Meta information extracted from the WSDL
     * - documentation: Identifies the amenities offered by the hotel. Refer to OpenTravel Code List Hotel Amenity Code (HAC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $PropertyAmenityType;
    /**
     * Constructor method for Amenity
     * @uses Amenity::setAmenityCode()
     * @uses Amenity::set_()
     * @uses Amenity::setPropertyAmenityType()
     * @param string $amenityCode
     * @param \StructType\RoomAmenityPrefType $_
     * @param string $propertyAmenityType
     */
    public function __construct($amenityCode = null, \StructType\RoomAmenityPrefType $_ = null, $propertyAmenityType = null)
    {
        $this
            ->setAmenityCode($amenityCode)
            ->set_($_)
            ->setPropertyAmenityType($propertyAmenityType);
    }
    /**
     * Get AmenityCode value
     * @return string|null
     */
    public function getAmenityCode()
    {
        return $this->AmenityCode;
    }
    /**
     * Set AmenityCode value
     * @param string $amenityCode
     * @return \StructType\Amenity
     */
    public function setAmenityCode($amenityCode = null)
    {
        // validation for constraint: string
        if (!is_null($amenityCode) && !is_string($amenityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amenityCode, true), gettype($amenityCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($amenityCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $amenityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($amenityCode, true)), __LINE__);
        }
        $this->AmenityCode = $amenityCode;
        return $this;
    }
    /**
     * Get _ value
     * @return \StructType\RoomAmenityPrefType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\RoomAmenityPrefType $_
     * @return \StructType\Amenity
     */
    public function set_(\StructType\RoomAmenityPrefType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PropertyAmenityType value
     * @return string|null
     */
    public function getPropertyAmenityType()
    {
        return $this->PropertyAmenityType;
    }
    /**
     * Set PropertyAmenityType value
     * @param string $propertyAmenityType
     * @return \StructType\Amenity
     */
    public function setPropertyAmenityType($propertyAmenityType = null)
    {
        // validation for constraint: string
        if (!is_null($propertyAmenityType) && !is_string($propertyAmenityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyAmenityType, true), gettype($propertyAmenityType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($propertyAmenityType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $propertyAmenityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($propertyAmenityType, true)), __LINE__);
        }
        $this->PropertyAmenityType = $propertyAmenityType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Amenity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
