<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllianceMember StructType
 * Meta information extracted from the WSDL
 * - documentation: Identification of a company that participates in an alliance or consortium to which the primary business entity identified in this profile belongs.
 * @subpackage Structs
 */
class AllianceMember extends CompanyNameType
{
    /**
     * The _
     * @var \StructType\CompanyNameType
     */
    public $_;
    /**
     * The MemberCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the alliance or consortium member by code. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $MemberCode;
    /**
     * Constructor method for AllianceMember
     * @uses AllianceMember::set_()
     * @uses AllianceMember::setMemberCode()
     * @param \StructType\CompanyNameType $_
     * @param string $memberCode
     */
    public function __construct(\StructType\CompanyNameType $_ = null, $memberCode = null)
    {
        $this
            ->set_($_)
            ->setMemberCode($memberCode);
    }
    /**
     * Get _ value
     * @return \StructType\CompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\CompanyNameType $_
     * @return \StructType\AllianceMember
     */
    public function set_(\StructType\CompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get MemberCode value
     * @return string|null
     */
    public function getMemberCode()
    {
        return $this->MemberCode;
    }
    /**
     * Set MemberCode value
     * @param string $memberCode
     * @return \StructType\AllianceMember
     */
    public function setMemberCode($memberCode = null)
    {
        // validation for constraint: string
        if (!is_null($memberCode) && !is_string($memberCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberCode, true), gettype($memberCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($memberCode) && mb_strlen($memberCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($memberCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($memberCode) && mb_strlen($memberCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($memberCode)), __LINE__);
        }
        $this->MemberCode = $memberCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllianceMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
