<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the data fields available for air tax. The element text of this type may contain a description of the tax. | A textual description.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class AirTaxType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: A textual description.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * @var string
     */
    public $_;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the code for the tax. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxCountry
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the country imposing the tax. | Specifies a 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - use: optional
     * @var string
     */
    public $TaxCountry;
    /**
     * The TaxName
     * Meta information extracted from the WSDL
     * - documentation: Identifies the tax code by name. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TaxName;
    /**
     * The TaxExemptInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the fare is exempt from the tax specified by the tax code. | This attribute is a candidate for deprecation. Its use is not recommended. Please instead use the new TaxTransactionType attribute which has taken its place.
     * Deprecation warning added in 2009A.
     * - use: optional
     * @var bool
     */
    public $TaxExemptInd;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The TaxTransactionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TaxTransactionType;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique reference for the tax type (commonly used for modification.) | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or
     * clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AirTaxType
     * @uses AirTaxType::set_()
     * @uses AirTaxType::setTaxCode()
     * @uses AirTaxType::setTaxCountry()
     * @uses AirTaxType::setTaxName()
     * @uses AirTaxType::setTaxExemptInd()
     * @uses AirTaxType::setOperation()
     * @uses AirTaxType::setTaxTransactionType()
     * @uses AirTaxType::setRPH()
     * @uses AirTaxType::setAmount()
     * @uses AirTaxType::setCurrencyCode()
     * @uses AirTaxType::setDecimalPlaces()
     * @param string $_
     * @param string $taxCode
     * @param string $taxCountry
     * @param string $taxName
     * @param bool $taxExemptInd
     * @param string $operation
     * @param string $taxTransactionType
     * @param string $rPH
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($_ = null, $taxCode = null, $taxCountry = null, $taxName = null, $taxExemptInd = null, $operation = null, $taxTransactionType = null, $rPH = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->set_($_)
            ->setTaxCode($taxCode)
            ->setTaxCountry($taxCountry)
            ->setTaxName($taxName)
            ->setTaxExemptInd($taxExemptInd)
            ->setOperation($operation)
            ->setTaxTransactionType($taxTransactionType)
            ->setRPH($rPH)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\AirTaxType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($_) && mb_strlen($_) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($_) && mb_strlen($_) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\AirTaxType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($taxCode) && mb_strlen($taxCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($taxCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxCode) && mb_strlen($taxCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxCountry value
     * @return string|null
     */
    public function getTaxCountry()
    {
        return $this->TaxCountry;
    }
    /**
     * Set TaxCountry value
     * @param string $taxCountry
     * @return \StructType\AirTaxType
     */
    public function setTaxCountry($taxCountry = null)
    {
        // validation for constraint: string
        if (!is_null($taxCountry) && !is_string($taxCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCountry, true), gettype($taxCountry)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($taxCountry) && !preg_match('/[a-zA-Z]{2}/', $taxCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($taxCountry, true)), __LINE__);
        }
        $this->TaxCountry = $taxCountry;
        return $this;
    }
    /**
     * Get TaxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->TaxName;
    }
    /**
     * Set TaxName value
     * @param string $taxName
     * @return \StructType\AirTaxType
     */
    public function setTaxName($taxName = null)
    {
        // validation for constraint: string
        if (!is_null($taxName) && !is_string($taxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxName, true), gettype($taxName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($taxName) && mb_strlen($taxName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($taxName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxName) && mb_strlen($taxName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxName)), __LINE__);
        }
        $this->TaxName = $taxName;
        return $this;
    }
    /**
     * Get TaxExemptInd value
     * @return bool|null
     */
    public function getTaxExemptInd()
    {
        return $this->TaxExemptInd;
    }
    /**
     * Set TaxExemptInd value
     * @param bool $taxExemptInd
     * @return \StructType\AirTaxType
     */
    public function setTaxExemptInd($taxExemptInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExemptInd) && !is_bool($taxExemptInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExemptInd, true), gettype($taxExemptInd)), __LINE__);
        }
        $this->TaxExemptInd = $taxExemptInd;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\AirTaxType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get TaxTransactionType value
     * @return string|null
     */
    public function getTaxTransactionType()
    {
        return $this->TaxTransactionType;
    }
    /**
     * Set TaxTransactionType value
     * @param string $taxTransactionType
     * @return \StructType\AirTaxType
     */
    public function setTaxTransactionType($taxTransactionType = null)
    {
        // validation for constraint: string
        if (!is_null($taxTransactionType) && !is_string($taxTransactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTransactionType, true), gettype($taxTransactionType)), __LINE__);
        }
        $this->TaxTransactionType = $taxTransactionType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AirTaxType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AirTaxType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AirTaxType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\AirTaxType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirTaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
