<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirSeats StructType
 * Meta information extracted from the WSDL
 * - documentation: A Collection of Air Seat
 * @subpackage Structs
 */
class AirSeats extends AbstractStructBase
{
    /**
     * The AirSeat
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\AirSeat[]
     */
    public $AirSeat;
    /**
     * Constructor method for AirSeats
     * @uses AirSeats::setAirSeat()
     * @param \StructType\AirSeat[] $airSeat
     */
    public function __construct(array $airSeat = array())
    {
        $this
            ->setAirSeat($airSeat);
    }
    /**
     * Get AirSeat value
     * @return \StructType\AirSeat[]|null
     */
    public function getAirSeat()
    {
        return $this->AirSeat;
    }
    /**
     * This method is responsible for validating the values passed to the setAirSeat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirSeat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirSeatForArrayConstraintsFromSetAirSeat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSeatsAirSeatItem) {
            // validation for constraint: itemType
            if (!$airSeatsAirSeatItem instanceof \StructType\AirSeat) {
                $invalidValues[] = is_object($airSeatsAirSeatItem) ? get_class($airSeatsAirSeatItem) : sprintf('%s(%s)', gettype($airSeatsAirSeatItem), var_export($airSeatsAirSeatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirSeat property can only contain items of type \StructType\AirSeat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirSeat value
     * @throws \InvalidArgumentException
     * @param \StructType\AirSeat[] $airSeat
     * @return \StructType\AirSeats
     */
    public function setAirSeat(array $airSeat = array())
    {
        // validation for constraint: array
        if ('' !== ($airSeatArrayErrorMessage = self::validateAirSeatForArrayConstraintsFromSetAirSeat($airSeat))) {
            throw new \InvalidArgumentException($airSeatArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($airSeat) && count($airSeat) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($airSeat)), __LINE__);
        }
        $this->AirSeat = $airSeat;
        return $this;
    }
    /**
     * Add item to AirSeat value
     * @throws \InvalidArgumentException
     * @param \StructType\AirSeat $item
     * @return \StructType\AirSeats
     */
    public function addToAirSeat(\StructType\AirSeat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirSeat) {
            throw new \InvalidArgumentException(sprintf('The AirSeat property can only contain items of type \StructType\AirSeat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AirSeat) && count($this->AirSeat) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AirSeat)), __LINE__);
        }
        $this->AirSeat[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirSeats
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
