<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirSeat StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the seat attributes. | A Seat within a row
 * @subpackage Structs
 */
class AirSeat extends AbstractStructBase
{
    /**
     * The SeatNumber
     * Meta information extracted from the WSDL
     * - documentation: Actual seat number within a particular row, typically A, B etc. | Used for an Alpha String, length exactly 1.
     * - base: xs:string
     * - pattern: [a-zA-Z]{1}
     * - type: AlphaLength1
     * - use: required
     * @var string
     */
    public $SeatNumber;
    /**
     * The SeatCharacteristics
     * Meta information extracted from the WSDL
     * - documentation: Describes the characteristics of a specific seat. Refer to OpenTravel Code List Air Seat Type (AST). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of
     * OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: ListOfOTA_CodeType
     * - use: required
     * @var string[]
     */
    public $SeatCharacteristics;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Should be used for situations in which a passenger in the input request is already assigned a seat. The RPH value will correspond to the RPH in the element TravelRefNumber within the element TravelerInfoSummary. | The Reference Place
     * Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The SeatAvailability
     * Meta information extracted from the WSDL
     * - documentation: Availability status of the particular seat. Refer to OpenTravel Code List Seat Availability (SAV). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $SeatAvailability;
    /**
     * The AirBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Allows that a seat may be assigned a class code. | Used for an Alpha String, length 1 to 2.
     * - base: xs:string
     * - pattern: [a-zA-Z]{1,2}
     * - type: AlphaLength1to2
     * - use: optional
     * @var string
     */
    public $AirBookDesigCode;
    /**
     * Constructor method for AirSeat
     * @uses AirSeat::setSeatNumber()
     * @uses AirSeat::setSeatCharacteristics()
     * @uses AirSeat::setRPH()
     * @uses AirSeat::setSeatAvailability()
     * @uses AirSeat::setAirBookDesigCode()
     * @param string $seatNumber
     * @param string[] $seatCharacteristics
     * @param string $rPH
     * @param string $seatAvailability
     * @param string $airBookDesigCode
     */
    public function __construct($seatNumber = null, array $seatCharacteristics = array(), $rPH = null, $seatAvailability = null, $airBookDesigCode = null)
    {
        $this
            ->setSeatNumber($seatNumber)
            ->setSeatCharacteristics($seatCharacteristics)
            ->setRPH($rPH)
            ->setSeatAvailability($seatAvailability)
            ->setAirBookDesigCode($airBookDesigCode);
    }
    /**
     * Get SeatNumber value
     * @return string
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\AirSeat
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{1})
        if (!is_null($seatNumber) && !preg_match('/[a-zA-Z]{1}/', $seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{1}', var_export($seatNumber, true)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get SeatCharacteristics value
     * @return string[]
     */
    public function getSeatCharacteristics()
    {
        return $this->SeatCharacteristics;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatCharacteristics method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatCharacteristics method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatCharacteristicsForArrayConstraintsFromSetSeatCharacteristics(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSeatSeatCharacteristicsItem) {
            // validation for constraint: itemType
            if (!is_string($airSeatSeatCharacteristicsItem)) {
                $invalidValues[] = is_object($airSeatSeatCharacteristicsItem) ? get_class($airSeatSeatCharacteristicsItem) : sprintf('%s(%s)', gettype($airSeatSeatCharacteristicsItem), var_export($airSeatSeatCharacteristicsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatCharacteristics property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatCharacteristics value
     * @param string[] $seatCharacteristics
     * @return \StructType\AirSeat
     */
    public function setSeatCharacteristics(array $seatCharacteristics = array())
    {
        // validation for constraint: list
        if ('' !== ($seatCharacteristicsArrayErrorMessage = self::validateSeatCharacteristicsForArrayConstraintsFromSetSeatCharacteristics($seatCharacteristics))) {
            throw new \InvalidArgumentException($seatCharacteristicsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($seatCharacteristics) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $seatCharacteristics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($seatCharacteristics, true)), __LINE__);
        }
        $this->SeatCharacteristics = is_array($seatCharacteristics) ? implode(' ', $seatCharacteristics) : null;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AirSeat
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get SeatAvailability value
     * @return string|null
     */
    public function getSeatAvailability()
    {
        return $this->SeatAvailability;
    }
    /**
     * Set SeatAvailability value
     * @param string $seatAvailability
     * @return \StructType\AirSeat
     */
    public function setSeatAvailability($seatAvailability = null)
    {
        // validation for constraint: string
        if (!is_null($seatAvailability) && !is_string($seatAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatAvailability, true), gettype($seatAvailability)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($seatAvailability) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $seatAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($seatAvailability, true)), __LINE__);
        }
        $this->SeatAvailability = $seatAvailability;
        return $this;
    }
    /**
     * Get AirBookDesigCode value
     * @return string|null
     */
    public function getAirBookDesigCode()
    {
        return $this->AirBookDesigCode;
    }
    /**
     * Set AirBookDesigCode value
     * @param string $airBookDesigCode
     * @return \StructType\AirSeat
     */
    public function setAirBookDesigCode($airBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airBookDesigCode) && !is_string($airBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airBookDesigCode, true), gettype($airBookDesigCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{1,2})
        if (!is_null($airBookDesigCode) && !preg_match('/[a-zA-Z]{1,2}/', $airBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{1,2}', var_export($airBookDesigCode, true)), __LINE__);
        }
        $this->AirBookDesigCode = $airBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirSeat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
