<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirRows StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of Air Rows
 * @subpackage Structs
 */
class AirRows extends AbstractStructBase
{
    /**
     * The AirRow
     * Meta information extracted from the WSDL
     * - documentation: Row in a Cabin class of a flight
     * - maxOccurs: 999
     * @var \StructType\RowDetailsType[]
     */
    public $AirRow;
    /**
     * Constructor method for AirRows
     * @uses AirRows::setAirRow()
     * @param \StructType\RowDetailsType[] $airRow
     */
    public function __construct(array $airRow = array())
    {
        $this
            ->setAirRow($airRow);
    }
    /**
     * Get AirRow value
     * @return \StructType\RowDetailsType[]|null
     */
    public function getAirRow()
    {
        return $this->AirRow;
    }
    /**
     * This method is responsible for validating the values passed to the setAirRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirRowForArrayConstraintsFromSetAirRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airRowsAirRowItem) {
            // validation for constraint: itemType
            if (!$airRowsAirRowItem instanceof \StructType\RowDetailsType) {
                $invalidValues[] = is_object($airRowsAirRowItem) ? get_class($airRowsAirRowItem) : sprintf('%s(%s)', gettype($airRowsAirRowItem), var_export($airRowsAirRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirRow property can only contain items of type \StructType\RowDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirRow value
     * @throws \InvalidArgumentException
     * @param \StructType\RowDetailsType[] $airRow
     * @return \StructType\AirRows
     */
    public function setAirRow(array $airRow = array())
    {
        // validation for constraint: array
        if ('' !== ($airRowArrayErrorMessage = self::validateAirRowForArrayConstraintsFromSetAirRow($airRow))) {
            throw new \InvalidArgumentException($airRowArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($airRow) && count($airRow) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($airRow)), __LINE__);
        }
        $this->AirRow = $airRow;
        return $this;
    }
    /**
     * Add item to AirRow value
     * @throws \InvalidArgumentException
     * @param \StructType\RowDetailsType $item
     * @return \StructType\AirRows
     */
    public function addToAirRow(\StructType\RowDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RowDetailsType) {
            throw new \InvalidArgumentException(sprintf('The AirRow property can only contain items of type \StructType\RowDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->AirRow) && count($this->AirRow) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->AirRow)), __LINE__);
        }
        $this->AirRow[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirRows
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
