<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReservationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all booking response information pertaining to a completed reservation.
 * @subpackage Structs
 */
class AirReservationType extends AbstractStructBase
{
    /**
     * The AirItinerary
     * Meta information extracted from the WSDL
     * - documentation: A collection of all flight segments requested for booking.
     * - minOccurs: 0
     * @var \StructType\AirItineraryType
     */
    public $AirItinerary;
    /**
     * The PriceInfo
     * Meta information extracted from the WSDL
     * - documentation: Pricing information for the air itinerary to be booked e.g. this data could come from the OTA_AirPriceRS data.
     * - minOccurs: 0
     * @var \StructType\BookingPriceInfoType
     */
    public $PriceInfo;
    /**
     * The TravelerInfo
     * Meta information extracted from the WSDL
     * - documentation: All traveler information relevant to a booking request.
     * - minOccurs: 0
     * @var \StructType\TravelerInfoType
     */
    public $TravelerInfo;
    /**
     * The Fulfillment
     * Meta information extracted from the WSDL
     * - documentation: All payment information relevant to a booking request.
     * - minOccurs: 0
     * @var \StructType\FulfillmentType
     */
    public $Fulfillment;
    /**
     * The Ticketing
     * Meta information extracted from the WSDL
     * - documentation: Information used to specify the ticketing arrangement or a summary of the associated ticket(s).
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\TicketingInfoType[]
     */
    public $Ticketing;
    /**
     * The Queues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Queues
     */
    public $Queues;
    /**
     * The BookingReferenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\BookingReferenceID[]
     */
    public $BookingReferenceID;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Textual information for the reservation.
     * - minOccurs: 0
     * @var \StructType\FormattedTextTextType
     */
    public $Comment;
    /**
     * The PricingOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingOverview
     */
    public $PricingOverview;
    /**
     * The LastModified
     * Meta information extracted from the WSDL
     * - documentation: Specifies the date the reservation was last modified. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $LastModified;
    /**
     * Constructor method for AirReservationType
     * @uses AirReservationType::setAirItinerary()
     * @uses AirReservationType::setPriceInfo()
     * @uses AirReservationType::setTravelerInfo()
     * @uses AirReservationType::setFulfillment()
     * @uses AirReservationType::setTicketing()
     * @uses AirReservationType::setQueues()
     * @uses AirReservationType::setBookingReferenceID()
     * @uses AirReservationType::setComment()
     * @uses AirReservationType::setPricingOverview()
     * @uses AirReservationType::setLastModified()
     * @param \StructType\AirItineraryType $airItinerary
     * @param \StructType\BookingPriceInfoType $priceInfo
     * @param \StructType\TravelerInfoType $travelerInfo
     * @param \StructType\FulfillmentType $fulfillment
     * @param \StructType\TicketingInfoType[] $ticketing
     * @param \StructType\Queues $queues
     * @param \StructType\BookingReferenceID[] $bookingReferenceID
     * @param \StructType\FormattedTextTextType $comment
     * @param \StructType\PricingOverview $pricingOverview
     * @param string $lastModified
     */
    public function __construct(\StructType\AirItineraryType $airItinerary = null, \StructType\BookingPriceInfoType $priceInfo = null, \StructType\TravelerInfoType $travelerInfo = null, \StructType\FulfillmentType $fulfillment = null, array $ticketing = array(), \StructType\Queues $queues = null, array $bookingReferenceID = array(), \StructType\FormattedTextTextType $comment = null, \StructType\PricingOverview $pricingOverview = null, $lastModified = null)
    {
        $this
            ->setAirItinerary($airItinerary)
            ->setPriceInfo($priceInfo)
            ->setTravelerInfo($travelerInfo)
            ->setFulfillment($fulfillment)
            ->setTicketing($ticketing)
            ->setQueues($queues)
            ->setBookingReferenceID($bookingReferenceID)
            ->setComment($comment)
            ->setPricingOverview($pricingOverview)
            ->setLastModified($lastModified);
    }
    /**
     * Get AirItinerary value
     * @return \StructType\AirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \StructType\AirItineraryType $airItinerary
     * @return \StructType\AirReservationType
     */
    public function setAirItinerary(\StructType\AirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get PriceInfo value
     * @return \StructType\BookingPriceInfoType|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * Set PriceInfo value
     * @param \StructType\BookingPriceInfoType $priceInfo
     * @return \StructType\AirReservationType
     */
    public function setPriceInfo(\StructType\BookingPriceInfoType $priceInfo = null)
    {
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return \StructType\TravelerInfoType|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param \StructType\TravelerInfoType $travelerInfo
     * @return \StructType\AirReservationType
     */
    public function setTravelerInfo(\StructType\TravelerInfoType $travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get Fulfillment value
     * @return \StructType\FulfillmentType|null
     */
    public function getFulfillment()
    {
        return $this->Fulfillment;
    }
    /**
     * Set Fulfillment value
     * @param \StructType\FulfillmentType $fulfillment
     * @return \StructType\AirReservationType
     */
    public function setFulfillment(\StructType\FulfillmentType $fulfillment = null)
    {
        $this->Fulfillment = $fulfillment;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \StructType\TicketingInfoType[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketingForArrayConstraintsFromSetTicketing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airReservationTypeTicketingItem) {
            // validation for constraint: itemType
            if (!$airReservationTypeTicketingItem instanceof \StructType\TicketingInfoType) {
                $invalidValues[] = is_object($airReservationTypeTicketingItem) ? get_class($airReservationTypeTicketingItem) : sprintf('%s(%s)', gettype($airReservationTypeTicketingItem), var_export($airReservationTypeTicketingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ticketing property can only contain items of type \StructType\TicketingInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketingInfoType[] $ticketing
     * @return \StructType\AirReservationType
     */
    public function setTicketing(array $ticketing = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketingArrayErrorMessage = self::validateTicketingForArrayConstraintsFromSetTicketing($ticketing))) {
            throw new \InvalidArgumentException($ticketingArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ticketing) && count($ticketing) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ticketing)), __LINE__);
        }
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketingInfoType $item
     * @return \StructType\AirReservationType
     */
    public function addToTicketing(\StructType\TicketingInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketingInfoType) {
            throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of type \StructType\TicketingInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Ticketing) && count($this->Ticketing) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Ticketing)), __LINE__);
        }
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Get Queues value
     * @return \StructType\Queues|null
     */
    public function getQueues()
    {
        return $this->Queues;
    }
    /**
     * Set Queues value
     * @param \StructType\Queues $queues
     * @return \StructType\AirReservationType
     */
    public function setQueues(\StructType\Queues $queues = null)
    {
        $this->Queues = $queues;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\BookingReferenceID[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingReferenceID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingReferenceID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingReferenceIDForArrayConstraintsFromSetBookingReferenceID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airReservationTypeBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$airReservationTypeBookingReferenceIDItem instanceof \StructType\BookingReferenceID) {
                $invalidValues[] = is_object($airReservationTypeBookingReferenceIDItem) ? get_class($airReservationTypeBookingReferenceIDItem) : sprintf('%s(%s)', gettype($airReservationTypeBookingReferenceIDItem), var_export($airReservationTypeBookingReferenceIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingReferenceID property can only contain items of type \StructType\BookingReferenceID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingReferenceID[] $bookingReferenceID
     * @return \StructType\AirReservationType
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingReferenceIDArrayErrorMessage = self::validateBookingReferenceIDForArrayConstraintsFromSetBookingReferenceID($bookingReferenceID))) {
            throw new \InvalidArgumentException($bookingReferenceIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($bookingReferenceID) && count($bookingReferenceID) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingReferenceID $item
     * @return \StructType\AirReservationType
     */
    public function addToBookingReferenceID(\StructType\BookingReferenceID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingReferenceID) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of type \StructType\BookingReferenceID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->BookingReferenceID) && count($this->BookingReferenceID) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->BookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\FormattedTextTextType|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param \StructType\FormattedTextTextType $comment
     * @return \StructType\AirReservationType
     */
    public function setComment(\StructType\FormattedTextTextType $comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get PricingOverview value
     * @return \StructType\PricingOverview|null
     */
    public function getPricingOverview()
    {
        return $this->PricingOverview;
    }
    /**
     * Set PricingOverview value
     * @param \StructType\PricingOverview $pricingOverview
     * @return \StructType\AirReservationType
     */
    public function setPricingOverview(\StructType\PricingOverview $pricingOverview = null)
    {
        $this->PricingOverview = $pricingOverview;
        return $this;
    }
    /**
     * Get LastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->LastModified;
    }
    /**
     * This method is responsible for validating the value passed to the setLastModified method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastModified method
     * This is a set of validation rules based on the union types associated to the property being set by the setLastModified method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastModifiedForUnionConstraintsFromSetLastModified($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set LastModified value
     * @param string $lastModified
     * @return \StructType\AirReservationType
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($lastModifiedUnionErrorMessage = self::validateLastModifiedForUnionConstraintsFromSetLastModified($lastModified))) {
            throw new \InvalidArgumentException($lastModifiedUnionErrorMessage, __LINE__);
        }
        $this->LastModified = $lastModified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
