<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvanceBooking StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the advance booking requirements. | Indicates whether or not advance booking is required for this rate and if so, what the advance booking requirements are.
 * @subpackage Structs
 */
class AdvanceBooking extends AbstractStructBase
{
    /**
     * The RequiredInd
     * Meta information extracted from the WSDL
     * - documentation: If true, advanced booking is required for this rate.
     * - use: optional
     * @var bool
     */
    public $RequiredInd;
    /**
     * The AbsoluteDeadline
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * @var string
     */
    public $AbsoluteDeadline;
    /**
     * The OffsetTimeUnit
     * @var string
     */
    public $OffsetTimeUnit;
    /**
     * The OffsetUnitMultiplier
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 0 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 0
     * @var int
     */
    public $OffsetUnitMultiplier;
    /**
     * The OffsetDropTime
     * @var string
     */
    public $OffsetDropTime;
    /**
     * The RulesApplyInd
     * Meta information extracted from the WSDL
     * - documentation: When true, rules apply to the advance booking requirement.
     * - use: optional
     * @var bool
     */
    public $RulesApplyInd;
    /**
     * Constructor method for AdvanceBooking
     * @uses AdvanceBooking::setRequiredInd()
     * @uses AdvanceBooking::setAbsoluteDeadline()
     * @uses AdvanceBooking::setOffsetTimeUnit()
     * @uses AdvanceBooking::setOffsetUnitMultiplier()
     * @uses AdvanceBooking::setOffsetDropTime()
     * @uses AdvanceBooking::setRulesApplyInd()
     * @param bool $requiredInd
     * @param string $absoluteDeadline
     * @param string $offsetTimeUnit
     * @param int $offsetUnitMultiplier
     * @param string $offsetDropTime
     * @param bool $rulesApplyInd
     */
    public function __construct($requiredInd = null, $absoluteDeadline = null, $offsetTimeUnit = null, $offsetUnitMultiplier = null, $offsetDropTime = null, $rulesApplyInd = null)
    {
        $this
            ->setRequiredInd($requiredInd)
            ->setAbsoluteDeadline($absoluteDeadline)
            ->setOffsetTimeUnit($offsetTimeUnit)
            ->setOffsetUnitMultiplier($offsetUnitMultiplier)
            ->setOffsetDropTime($offsetDropTime)
            ->setRulesApplyInd($rulesApplyInd);
    }
    /**
     * Get RequiredInd value
     * @return bool|null
     */
    public function getRequiredInd()
    {
        return $this->RequiredInd;
    }
    /**
     * Set RequiredInd value
     * @param bool $requiredInd
     * @return \StructType\AdvanceBooking
     */
    public function setRequiredInd($requiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiredInd) && !is_bool($requiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiredInd, true), gettype($requiredInd)), __LINE__);
        }
        $this->RequiredInd = $requiredInd;
        return $this;
    }
    /**
     * Get AbsoluteDeadline value
     * @return string|null
     */
    public function getAbsoluteDeadline()
    {
        return $this->AbsoluteDeadline;
    }
    /**
     * This method is responsible for validating the value passed to the setAbsoluteDeadline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbsoluteDeadline method
     * This is a set of validation rules based on the union types associated to the property being set by the setAbsoluteDeadline method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbsoluteDeadlineForUnionConstraintsFromSetAbsoluteDeadline($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set AbsoluteDeadline value
     * @param string $absoluteDeadline
     * @return \StructType\AdvanceBooking
     */
    public function setAbsoluteDeadline($absoluteDeadline = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteDeadline) && !is_string($absoluteDeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteDeadline, true), gettype($absoluteDeadline)), __LINE__);
        }
        // validation for constraint: union(dateTime, time)
        if ('' !== ($absoluteDeadlineUnionErrorMessage = self::validateAbsoluteDeadlineForUnionConstraintsFromSetAbsoluteDeadline($absoluteDeadline))) {
            throw new \InvalidArgumentException($absoluteDeadlineUnionErrorMessage, __LINE__);
        }
        $this->AbsoluteDeadline = $absoluteDeadline;
        return $this;
    }
    /**
     * Get OffsetTimeUnit value
     * @return string|null
     */
    public function getOffsetTimeUnit()
    {
        return $this->OffsetTimeUnit;
    }
    /**
     * Set OffsetTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $offsetTimeUnit
     * @return \StructType\AdvanceBooking
     */
    public function setOffsetTimeUnit($offsetTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($offsetTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($offsetTimeUnit) ? implode(', ', $offsetTimeUnit) : var_export($offsetTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->OffsetTimeUnit = $offsetTimeUnit;
        return $this;
    }
    /**
     * Get OffsetUnitMultiplier value
     * @return int|null
     */
    public function getOffsetUnitMultiplier()
    {
        return $this->OffsetUnitMultiplier;
    }
    /**
     * Set OffsetUnitMultiplier value
     * @param int $offsetUnitMultiplier
     * @return \StructType\AdvanceBooking
     */
    public function setOffsetUnitMultiplier($offsetUnitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($offsetUnitMultiplier) && !(is_int($offsetUnitMultiplier) || ctype_digit($offsetUnitMultiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offsetUnitMultiplier, true), gettype($offsetUnitMultiplier)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($offsetUnitMultiplier) && $offsetUnitMultiplier > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($offsetUnitMultiplier, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($offsetUnitMultiplier) && $offsetUnitMultiplier < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($offsetUnitMultiplier, true)), __LINE__);
        }
        $this->OffsetUnitMultiplier = $offsetUnitMultiplier;
        return $this;
    }
    /**
     * Get OffsetDropTime value
     * @return string|null
     */
    public function getOffsetDropTime()
    {
        return $this->OffsetDropTime;
    }
    /**
     * Set OffsetDropTime value
     * @param string $offsetDropTime
     * @return \StructType\AdvanceBooking
     */
    public function setOffsetDropTime($offsetDropTime = null)
    {
        // validation for constraint: string
        if (!is_null($offsetDropTime) && !is_string($offsetDropTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetDropTime, true), gettype($offsetDropTime)), __LINE__);
        }
        $this->OffsetDropTime = $offsetDropTime;
        return $this;
    }
    /**
     * Get RulesApplyInd value
     * @return bool|null
     */
    public function getRulesApplyInd()
    {
        return $this->RulesApplyInd;
    }
    /**
     * Set RulesApplyInd value
     * @param bool $rulesApplyInd
     * @return \StructType\AdvanceBooking
     */
    public function setRulesApplyInd($rulesApplyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rulesApplyInd) && !is_bool($rulesApplyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rulesApplyInd, true), gettype($rulesApplyInd)), __LINE__);
        }
        $this->RulesApplyInd = $rulesApplyInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdvanceBooking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
