<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalPersonNames StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for additional person names.
 * @subpackage Structs
 */
class AdditionalPersonNames extends AbstractStructBase
{
    /**
     * The AdditionalPersonName
     * Meta information extracted from the WSDL
     * - documentation: The name of an additional person listed on this document. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - maxOccurs: 99
     * - minLength: 1
     * @var string[]
     */
    public $AdditionalPersonName;
    /**
     * Constructor method for AdditionalPersonNames
     * @uses AdditionalPersonNames::setAdditionalPersonName()
     * @param string[] $additionalPersonName
     */
    public function __construct(array $additionalPersonName = array())
    {
        $this
            ->setAdditionalPersonName($additionalPersonName);
    }
    /**
     * Get AdditionalPersonName value
     * @return string[]|null
     */
    public function getAdditionalPersonName()
    {
        return $this->AdditionalPersonName;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalPersonName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalPersonName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalPersonNameForArrayConstraintsFromSetAdditionalPersonName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalPersonNamesAdditionalPersonNameItem) {
            // validation for constraint: itemType
            if (!is_string($additionalPersonNamesAdditionalPersonNameItem)) {
                $invalidValues[] = is_object($additionalPersonNamesAdditionalPersonNameItem) ? get_class($additionalPersonNamesAdditionalPersonNameItem) : sprintf('%s(%s)', gettype($additionalPersonNamesAdditionalPersonNameItem), var_export($additionalPersonNamesAdditionalPersonNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalPersonName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAdditionalPersonName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalPersonName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalPersonNameForMaxLengthConstraintFromSetAdditionalPersonName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalPersonNamesAdditionalPersonNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($additionalPersonNamesAdditionalPersonNameItem) > 64) {
                $invalidValues[] = var_export($additionalPersonNamesAdditionalPersonNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAdditionalPersonName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalPersonName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalPersonNameForMinLengthConstraintFromSetAdditionalPersonName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalPersonNamesAdditionalPersonNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($additionalPersonNamesAdditionalPersonNameItem) < 1) {
                $invalidValues[] = var_export($additionalPersonNamesAdditionalPersonNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalPersonName value
     * @throws \InvalidArgumentException
     * @param string[] $additionalPersonName
     * @return \StructType\AdditionalPersonNames
     */
    public function setAdditionalPersonName(array $additionalPersonName = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalPersonNameArrayErrorMessage = self::validateAdditionalPersonNameForArrayConstraintsFromSetAdditionalPersonName($additionalPersonName))) {
            throw new \InvalidArgumentException($additionalPersonNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($additionalPersonNameMaxLengthErrorMessage = self::validateAdditionalPersonNameForMaxLengthConstraintFromSetAdditionalPersonName($additionalPersonName))) {
            throw new \InvalidArgumentException($additionalPersonNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($additionalPersonName) && count($additionalPersonName) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($additionalPersonName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($additionalPersonNameMinLengthErrorMessage = self::validateAdditionalPersonNameForMinLengthConstraintFromSetAdditionalPersonName($additionalPersonName))) {
            throw new \InvalidArgumentException($additionalPersonNameMinLengthErrorMessage, __LINE__);
        }
        $this->AdditionalPersonName = $additionalPersonName;
        return $this;
    }
    /**
     * Add item to AdditionalPersonName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AdditionalPersonNames
     */
    public function addToAdditionalPersonName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AdditionalPersonName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AdditionalPersonName) && count($this->AdditionalPersonName) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AdditionalPersonName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->AdditionalPersonName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalPersonNames
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
