<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountAuthorization StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies account information about the customer seeking authorization.
 * @subpackage Structs
 */
class AccountAuthorization extends AbstractStructBase
{
    /**
     * The AccountInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountInfo
     */
    public $AccountInfo;
    /**
     * The NonISO_CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Specifying the currency used in the authorization, when it isn't a ISO 4217, three alpha code (e.g., points, miles). | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $NonISO_CurrencyCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AccountAuthorization
     * @uses AccountAuthorization::setAccountInfo()
     * @uses AccountAuthorization::setNonISO_CurrencyCode()
     * @uses AccountAuthorization::setAmount()
     * @uses AccountAuthorization::setCurrencyCode()
     * @uses AccountAuthorization::setDecimalPlaces()
     * @param \StructType\AccountInfo $accountInfo
     * @param string $nonISO_CurrencyCode
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(\StructType\AccountInfo $accountInfo = null, $nonISO_CurrencyCode = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setAccountInfo($accountInfo)
            ->setNonISO_CurrencyCode($nonISO_CurrencyCode)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get AccountInfo value
     * @return \StructType\AccountInfo|null
     */
    public function getAccountInfo()
    {
        return $this->AccountInfo;
    }
    /**
     * Set AccountInfo value
     * @param \StructType\AccountInfo $accountInfo
     * @return \StructType\AccountAuthorization
     */
    public function setAccountInfo(\StructType\AccountInfo $accountInfo = null)
    {
        $this->AccountInfo = $accountInfo;
        return $this;
    }
    /**
     * Get NonISO_CurrencyCode value
     * @return string|null
     */
    public function getNonISO_CurrencyCode()
    {
        return $this->NonISO_CurrencyCode;
    }
    /**
     * Set NonISO_CurrencyCode value
     * @param string $nonISO_CurrencyCode
     * @return \StructType\AccountAuthorization
     */
    public function setNonISO_CurrencyCode($nonISO_CurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($nonISO_CurrencyCode) && !is_string($nonISO_CurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonISO_CurrencyCode, true), gettype($nonISO_CurrencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($nonISO_CurrencyCode) && mb_strlen($nonISO_CurrencyCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($nonISO_CurrencyCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nonISO_CurrencyCode) && mb_strlen($nonISO_CurrencyCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nonISO_CurrencyCode)), __LINE__);
        }
        $this->NonISO_CurrencyCode = $nonISO_CurrencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AccountAuthorization
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AccountAuthorization
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\AccountAuthorization
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountAuthorization
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
