<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptablePayments StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of acceptable methods of payment.
 * @subpackage Structs
 */
class AcceptablePayments extends AbstractStructBase
{
    /**
     * The AcceptablePayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * @var \StructType\AcceptablePayment[]
     */
    public $AcceptablePayment;
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the type of payemt (i.e., guarantee, deposit). Refer to OpenTravel Code List Payment Type (PMT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * Constructor method for AcceptablePayments
     * @uses AcceptablePayments::setAcceptablePayment()
     * @uses AcceptablePayments::setPaymentTypeCode()
     * @param \StructType\AcceptablePayment[] $acceptablePayment
     * @param string $paymentTypeCode
     */
    public function __construct(array $acceptablePayment = array(), $paymentTypeCode = null)
    {
        $this
            ->setAcceptablePayment($acceptablePayment)
            ->setPaymentTypeCode($paymentTypeCode);
    }
    /**
     * Get AcceptablePayment value
     * @return \StructType\AcceptablePayment[]|null
     */
    public function getAcceptablePayment()
    {
        return $this->AcceptablePayment;
    }
    /**
     * This method is responsible for validating the values passed to the setAcceptablePayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptablePayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcceptablePaymentForArrayConstraintsFromSetAcceptablePayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $acceptablePaymentsAcceptablePaymentItem) {
            // validation for constraint: itemType
            if (!$acceptablePaymentsAcceptablePaymentItem instanceof \StructType\AcceptablePayment) {
                $invalidValues[] = is_object($acceptablePaymentsAcceptablePaymentItem) ? get_class($acceptablePaymentsAcceptablePaymentItem) : sprintf('%s(%s)', gettype($acceptablePaymentsAcceptablePaymentItem), var_export($acceptablePaymentsAcceptablePaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AcceptablePayment property can only contain items of type \StructType\AcceptablePayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AcceptablePayment value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptablePayment[] $acceptablePayment
     * @return \StructType\AcceptablePayments
     */
    public function setAcceptablePayment(array $acceptablePayment = array())
    {
        // validation for constraint: array
        if ('' !== ($acceptablePaymentArrayErrorMessage = self::validateAcceptablePaymentForArrayConstraintsFromSetAcceptablePayment($acceptablePayment))) {
            throw new \InvalidArgumentException($acceptablePaymentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($acceptablePayment) && count($acceptablePayment) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($acceptablePayment)), __LINE__);
        }
        $this->AcceptablePayment = $acceptablePayment;
        return $this;
    }
    /**
     * Add item to AcceptablePayment value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptablePayment $item
     * @return \StructType\AcceptablePayments
     */
    public function addToAcceptablePayment(\StructType\AcceptablePayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AcceptablePayment) {
            throw new \InvalidArgumentException(sprintf('The AcceptablePayment property can only contain items of type \StructType\AcceptablePayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->AcceptablePayment) && count($this->AcceptablePayment) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->AcceptablePayment)), __LINE__);
        }
        $this->AcceptablePayment[] = $item;
        return $this;
    }
    /**
     * Get PaymentTypeCode value
     * @return string|null
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\AcceptablePayments
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($paymentTypeCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($paymentTypeCode, true)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptablePayments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
