<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptablePayment StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies an acceptable method of payment.
 * @subpackage Structs
 */
class AcceptablePayment extends AbstractStructBase
{
    /**
     * The CreditCardCode
     * Meta information extracted from the WSDL
     * - documentation: The acceptable credit card for this payment rule.
     * - use: optional
     * @var string
     */
    public $CreditCardCode;
    /**
     * Constructor method for AcceptablePayment
     * @uses AcceptablePayment::setCreditCardCode()
     * @param string $creditCardCode
     */
    public function __construct($creditCardCode = null)
    {
        $this
            ->setCreditCardCode($creditCardCode);
    }
    /**
     * Get CreditCardCode value
     * @return string|null
     */
    public function getCreditCardCode()
    {
        return $this->CreditCardCode;
    }
    /**
     * Set CreditCardCode value
     * @uses \EnumType\PaymentCardCodeType::valueIsValid()
     * @uses \EnumType\PaymentCardCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditCardCode
     * @return \StructType\AcceptablePayment
     */
    public function setCreditCardCode($creditCardCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentCardCodeType::valueIsValid($creditCardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentCardCodeType', is_array($creditCardCode) ? implode(', ', $creditCardCode) : var_export($creditCardCode, true), implode(', ', \EnumType\PaymentCardCodeType::getValidValues())), __LINE__);
        }
        $this->CreditCardCode = $creditCardCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptablePayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
