<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptableGuarantee StructType
 * Meta information extracted from the WSDL
 * - documentation: The guarantee information.
 * @subpackage Structs
 */
class AcceptableGuarantee extends GuaranteeType
{
    /**
     * The GuaranteePolicyType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $GuaranteePolicyType;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Payment Type (PMT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $PaymentType;
    /**
     * The UnacceptablePaymentType
     * Meta information extracted from the WSDL
     * - documentation: Used to denote unacceptable forms of payment. Refer to OpenTravel Code List Payment Type (PMT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $UnacceptablePaymentType;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AcceptableGuarantee
     * @uses AcceptableGuarantee::setGuaranteePolicyType()
     * @uses AcceptableGuarantee::setPaymentType()
     * @uses AcceptableGuarantee::setUnacceptablePaymentType()
     * @uses AcceptableGuarantee::setCurrencyCode()
     * @uses AcceptableGuarantee::setDecimalPlaces()
     * @param string $guaranteePolicyType
     * @param string $paymentType
     * @param string $unacceptablePaymentType
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($guaranteePolicyType = null, $paymentType = null, $unacceptablePaymentType = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setGuaranteePolicyType($guaranteePolicyType)
            ->setPaymentType($paymentType)
            ->setUnacceptablePaymentType($unacceptablePaymentType)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get GuaranteePolicyType value
     * @return string|null
     */
    public function getGuaranteePolicyType()
    {
        return $this->GuaranteePolicyType;
    }
    /**
     * Set GuaranteePolicyType value
     * @param string $guaranteePolicyType
     * @return \StructType\AcceptableGuarantee
     */
    public function setGuaranteePolicyType($guaranteePolicyType = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteePolicyType) && !is_string($guaranteePolicyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteePolicyType, true), gettype($guaranteePolicyType)), __LINE__);
        }
        $this->GuaranteePolicyType = $guaranteePolicyType;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\AcceptableGuarantee
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($paymentType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($paymentType, true)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get UnacceptablePaymentType value
     * @return string|null
     */
    public function getUnacceptablePaymentType()
    {
        return $this->UnacceptablePaymentType;
    }
    /**
     * Set UnacceptablePaymentType value
     * @param string $unacceptablePaymentType
     * @return \StructType\AcceptableGuarantee
     */
    public function setUnacceptablePaymentType($unacceptablePaymentType = null)
    {
        // validation for constraint: string
        if (!is_null($unacceptablePaymentType) && !is_string($unacceptablePaymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unacceptablePaymentType, true), gettype($unacceptablePaymentType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($unacceptablePaymentType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $unacceptablePaymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($unacceptablePaymentType, true)), __LINE__);
        }
        $this->UnacceptablePaymentType = $unacceptablePaymentType;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AcceptableGuarantee
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\AcceptableGuarantee
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptableGuarantee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
