<?php

namespace EnumType;

/**
 * This class stands for SourceType EnumType
 * @subpackage Enumerations
 */
class SourceType
{
    /**
     * Constant for value 'CID_NotOnCard'
     * @return string 'CID_NotOnCard'
     */
    const VALUE_CID_NOT_ON_CARD = 'CID_NotOnCard';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CID_NOT_ON_CARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CID_NOT_ON_CARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
