<?php

namespace EnumType;

/**
 * This class stands for Restriction EnumType
 * @subpackage Enumerations
 */
class Restriction
{
    /**
     * Constant for value 'TravelAgent'
     * @return string 'TravelAgent'
     */
    const VALUE_TRAVEL_AGENT = 'TravelAgent';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRAVEL_AGENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRAVEL_AGENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
