<?php

namespace EnumType;

/**
 * This class stands for LocationDetailVehicleInfoType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The LocationDetailVehicleInfoType defines a set of valid values for the textual information about vehicles available at a rental facility.
 * @subpackage Enumerations
 */
class LocationDetailVehicleInfoType
{
    /**
     * Constant for value 'GeneralInformation'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes general information about the vehicles that are typically offered for rental.
     * @return string 'GeneralInformation'
     */
    const VALUE_GENERAL_INFORMATION = 'GeneralInformation';
    /**
     * Constant for value 'Disclaimer'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information provides the disclaimers about the vehicles that are typically offered for rental. This may be typically that not all vehicles may be available at any one time, for example.
     * @return string 'Disclaimer'
     */
    const VALUE_DISCLAIMER = 'Disclaimer';
    /**
     * Constant for value 'AdvancedBooking'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes any advance booking requiremennts about one or more vehicle types. Some unusual vehicles may not be available at short notice.
     * @return string 'AdvancedBooking'
     */
    const VALUE_ADVANCED_BOOKING = 'AdvancedBooking';
    /**
     * Constant for value 'NonSmokingVehicles'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes general information about non-smoking vehicles that may be offered for rental.
     * @return string 'NonSmokingVehicles'
     */
    const VALUE_NON_SMOKING_VEHICLES = 'NonSmokingVehicles';
    /**
     * Constant for value 'SpecialityVehicles'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes special, unusual or high-end vehicles that may be offered for rental.
     * @return string 'SpecialityVehicles'
     */
    const VALUE_SPECIALITY_VEHICLES = 'SpecialityVehicles';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GENERAL_INFORMATION
     * @uses self::VALUE_DISCLAIMER
     * @uses self::VALUE_ADVANCED_BOOKING
     * @uses self::VALUE_NON_SMOKING_VEHICLES
     * @uses self::VALUE_SPECIALITY_VEHICLES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GENERAL_INFORMATION,
            self::VALUE_DISCLAIMER,
            self::VALUE_ADVANCED_BOOKING,
            self::VALUE_NON_SMOKING_VEHICLES,
            self::VALUE_SPECIALITY_VEHICLES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
