<?php

namespace EnumType;

/**
 * This class stands for LocationDetailRequirementInfoType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The LocationDetailRequirementInfoType simple type defines a set of valid values for the textual information about the requirements when renting from a rental facility.
 * @subpackage Enumerations
 */
class LocationDetailRequirementInfoType
{
    /**
     * Constant for value 'OneWayRental'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes the requirements and restrictions concerning one way rentals
     * @return string 'OneWayRental'
     */
    const VALUE_ONE_WAY_RENTAL = 'OneWayRental';
    /**
     * Constant for value 'Geographic'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes the requirements and restrictions concerning geographic limitations, for example, the vehicle may only be driven into adjoining states, the vehicle may not be taken in Mexico, etc.
     * @return string 'Geographic'
     */
    const VALUE_GEOGRAPHIC = 'Geographic';
    /**
     * Constant for value 'DropOff'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes the requirements and restrictions concerning the dropoff, or return, of the vehicle.
     * @return string 'DropOff'
     */
    const VALUE_DROP_OFF = 'DropOff';
    /**
     * Constant for value 'License'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes the requirements and restrictions concerning the renter's drivers license and associated factors, such as driving record, violations, etc.
     * @return string 'License'
     */
    const VALUE_LICENSE = 'License';
    /**
     * Constant for value 'Insurance'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes the requirements and restrictions concerning insurance for the vehicle that is being rented.
     * @return string 'Insurance'
     */
    const VALUE_INSURANCE = 'Insurance';
    /**
     * Constant for value 'Eligibility'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes the requirements and restrictions concerning the eligibility of those who may rent from a specific rental facility. For example, a rental facility may be at the premises of a
     * corporation, and only those corporate employees may rent from that location. The facility is not considered a public rental facility.
     * @return string 'Eligibility'
     */
    const VALUE_ELIGIBILITY = 'Eligibility';
    /**
     * Constant for value 'Miscellaneous'
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the associated information describes miscellaneous requirements and restrictions.
     * @return string 'Miscellaneous'
     */
    const VALUE_MISCELLANEOUS = 'Miscellaneous';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONE_WAY_RENTAL
     * @uses self::VALUE_GEOGRAPHIC
     * @uses self::VALUE_DROP_OFF
     * @uses self::VALUE_LICENSE
     * @uses self::VALUE_INSURANCE
     * @uses self::VALUE_ELIGIBILITY
     * @uses self::VALUE_MISCELLANEOUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONE_WAY_RENTAL,
            self::VALUE_GEOGRAPHIC,
            self::VALUE_DROP_OFF,
            self::VALUE_LICENSE,
            self::VALUE_INSURANCE,
            self::VALUE_ELIGIBILITY,
            self::VALUE_MISCELLANEOUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
