<?php

namespace EnumType;

/**
 * This class stands for FaultSubcodeValues EnumType
 * @subpackage Enumerations
 */
class FaultSubcodeValues
{
    /**
     * Constant for value 'wsa:InvalidMessageInformationHeader'
     * @return string 'wsa:InvalidMessageInformationHeader'
     */
    const VALUE_WSA_INVALID_MESSAGE_INFORMATION_HEADER = 'wsa:InvalidMessageInformationHeader';
    /**
     * Constant for value 'wsa:MessageInformationHeaderRequired'
     * @return string 'wsa:MessageInformationHeaderRequired'
     */
    const VALUE_WSA_MESSAGE_INFORMATION_HEADER_REQUIRED = 'wsa:MessageInformationHeaderRequired';
    /**
     * Constant for value 'wsa:DestinationUnreachable'
     * @return string 'wsa:DestinationUnreachable'
     */
    const VALUE_WSA_DESTINATION_UNREACHABLE = 'wsa:DestinationUnreachable';
    /**
     * Constant for value 'wsa:ActionNotSupported'
     * @return string 'wsa:ActionNotSupported'
     */
    const VALUE_WSA_ACTION_NOT_SUPPORTED = 'wsa:ActionNotSupported';
    /**
     * Constant for value 'wsa:EndpointUnavailable'
     * @return string 'wsa:EndpointUnavailable'
     */
    const VALUE_WSA_ENDPOINT_UNAVAILABLE = 'wsa:EndpointUnavailable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WSA_INVALID_MESSAGE_INFORMATION_HEADER
     * @uses self::VALUE_WSA_MESSAGE_INFORMATION_HEADER_REQUIRED
     * @uses self::VALUE_WSA_DESTINATION_UNREACHABLE
     * @uses self::VALUE_WSA_ACTION_NOT_SUPPORTED
     * @uses self::VALUE_WSA_ENDPOINT_UNAVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WSA_INVALID_MESSAGE_INFORMATION_HEADER,
            self::VALUE_WSA_MESSAGE_INFORMATION_HEADER_REQUIRED,
            self::VALUE_WSA_DESTINATION_UNREACHABLE,
            self::VALUE_WSA_ACTION_NOT_SUPPORTED,
            self::VALUE_WSA_ENDPOINT_UNAVAILABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
