<?php

namespace EnumType;

/**
 * This class stands for AdditionalRule EnumType
 * @subpackage Enumerations
 */
class AdditionalRule
{
    /**
     * Constant for value 'ID_Required'
     * @return string 'ID_Required'
     */
    const VALUE_ID_REQUIRED = 'ID_Required';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ID_REQUIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ID_REQUIRED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
