<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'AttributedDateTime' => '\\StructType\\AttributedDateTime',
            'AttributedURI' => '\\StructType\\AttributedURI',
            'TimestampType' => '\\StructType\\TimestampType',
            'SignatureType' => '\\StructType\\SignatureType',
            'SignatureValueType' => '\\StructType\\SignatureValueType',
            'SignedInfoType' => '\\StructType\\SignedInfoType',
            'CanonicalizationMethodType' => '\\StructType\\CanonicalizationMethodType',
            'SignatureMethodType' => '\\StructType\\SignatureMethodType',
            'ReferenceType' => '\\StructType\\ReferenceType',
            'TransformsType' => '\\StructType\\TransformsType',
            'TransformType' => '\\StructType\\TransformType',
            'DigestMethodType' => '\\StructType\\DigestMethodType',
            'KeyInfoType' => '\\StructType\\KeyInfoType',
            'KeyValueType' => '\\StructType\\KeyValueType',
            'RetrievalMethodType' => '\\StructType\\RetrievalMethodType',
            'X509DataType' => '\\StructType\\X509DataType',
            'X509IssuerSerialType' => '\\StructType\\X509IssuerSerialType',
            'PGPDataType' => '\\StructType\\PGPDataType',
            'SPKIDataType' => '\\StructType\\SPKIDataType',
            'ObjectType' => '\\StructType\\ObjectType',
            'ManifestType' => '\\StructType\\ManifestType',
            'SignaturePropertiesType' => '\\StructType\\SignaturePropertiesType',
            'SignaturePropertyType' => '\\StructType\\SignaturePropertyType',
            'DSAKeyValueType' => '\\StructType\\DSAKeyValueType',
            'RSAKeyValueType' => '\\StructType\\RSAKeyValueType',
            'AttributedString' => '\\StructType\\AttributedString',
            'PasswordString' => '\\StructType\\PasswordString',
            'EncodedString' => '\\StructType\\EncodedString',
            'UsernameTokenType' => '\\StructType\\UsernameTokenType',
            'BinarySecurityTokenType' => '\\StructType\\BinarySecurityTokenType',
            'KeyIdentifierType' => '\\StructType\\KeyIdentifierType',
            'EmbeddedType' => '\\StructType\\EmbeddedType',
            'SecurityTokenReferenceType' => '\\StructType\\SecurityTokenReferenceType',
            'SecurityHeaderType' => '\\StructType\\SecurityHeaderType',
            'TransformationParametersType' => '\\StructType\\TransformationParametersType',
            'EndpointReferenceType' => '\\StructType\\EndpointReferenceType',
            'ReferencePropertiesType' => '\\StructType\\ReferencePropertiesType',
            'ReferenceParametersType' => '\\StructType\\ReferenceParametersType',
            'ServiceNameType' => '\\StructType\\ServiceNameType',
            'Relationship' => '\\StructType\\Relationship',
            'ReplyAfterType' => '\\StructType\\ReplyAfterType',
            'RetryAfterType' => '\\StructType\\RetryAfterType',
            'AttributedQName' => '\\StructType\\AttributedQName',
            'AcceptablePaymentCardsInfoType' => '\\StructType\\AcceptablePaymentCardsInfoType',
            'AcceptablePaymentCards' => '\\StructType\\AcceptablePaymentCards',
            'AcceptablePaymentCard' => '\\StructType\\AcceptablePaymentCard',
            'AcceptedPaymentsType' => '\\StructType\\AcceptedPaymentsType',
            'AddressInfoType' => '\\StructType\\AddressInfoType',
            'AddressType' => '\\StructType\\AddressType',
            'StreetNmbr' => '\\StructType\\StreetNmbr',
            'BldgRoom' => '\\StructType\\BldgRoom',
            'BankAcctType' => '\\StructType\\BankAcctType',
            'BlackoutDateType' => '\\StructType\\BlackoutDateType',
            'CancelInfoRQType' => '\\StructType\\CancelInfoRQType',
            'CancelInfoRSType' => '\\StructType\\CancelInfoRSType',
            'CancelRules' => '\\StructType\\CancelRules',
            'CancelRuleType' => '\\StructType\\CancelRuleType',
            'CommentType' => '\\StructType\\CommentType',
            'Comment' => '\\StructType\\Comment',
            'CommissionType' => '\\StructType\\CommissionType',
            'CommissionableAmount' => '\\StructType\\CommissionableAmount',
            'PrepaidAmount' => '\\StructType\\PrepaidAmount',
            'FlatCommission' => '\\StructType\\FlatCommission',
            'CommissionPayableAmount' => '\\StructType\\CommissionPayableAmount',
            'CompanyNameType' => '\\StructType\\CompanyNameType',
            'ConnectionType' => '\\StructType\\ConnectionType',
            'ConnectionLocation' => '\\StructType\\ConnectionLocation',
            'ContactPersonType' => '\\StructType\\ContactPersonType',
            'Telephone' => '\\StructType\\Telephone',
            'CountryNameType' => '\\StructType\\CountryNameType',
            'CustomerType' => '\\StructType\\CustomerType',
            'Email' => '\\StructType\\Email',
            'Address' => '\\StructType\\Address',
            'URL' => '\\StructType\\URL',
            'CitizenCountryName' => '\\StructType\\CitizenCountryName',
            'PhysChallName' => '\\StructType\\PhysChallName',
            'PaymentForm' => '\\StructType\\PaymentForm',
            'AssociatedSupplier' => '\\StructType\\AssociatedSupplier',
            'CustLoyalty' => '\\StructType\\CustLoyalty',
            'AdditionalLanguage' => '\\StructType\\AdditionalLanguage',
            'DateTimeSpanType' => '\\StructType\\DateTimeSpanType',
            'StartDateWindow' => '\\StructType\\StartDateWindow',
            'EndDateWindow' => '\\StructType\\EndDateWindow',
            'DirectBillType' => '\\StructType\\DirectBillType',
            'CompanyName' => '\\StructType\\CompanyName',
            'DocumentType' => '\\StructType\\DocumentType',
            'AdditionalPersonNames' => '\\StructType\\AdditionalPersonNames',
            'EmailType' => '\\StructType\\EmailType',
            'EmployeeInfoType' => '\\StructType\\EmployeeInfoType',
            'EquipmentType' => '\\StructType\\EquipmentType',
            'ErrorType' => '\\StructType\\ErrorType',
            'ErrorsType' => '\\StructType\\ErrorsType',
            'FeeType' => '\\StructType\\FeeType',
            'FeesType' => '\\StructType\\FeesType',
            'FlightSegmentBaseType' => '\\StructType\\FlightSegmentBaseType',
            'DepartureAirport' => '\\StructType\\DepartureAirport',
            'ArrivalAirport' => '\\StructType\\ArrivalAirport',
            'FormattedTextSubSectionType' => '\\StructType\\FormattedTextSubSectionType',
            'FormattedTextTextType' => '\\StructType\\FormattedTextTextType',
            'FormattedTextType' => '\\StructType\\FormattedTextType',
            'FreeTextType' => '\\StructType\\FreeTextType',
            'ImageDescriptionType' => '\\StructType\\ImageDescriptionType',
            'ImageFormat' => '\\StructType\\ImageFormat',
            'Description' => '\\StructType\\Description',
            'ImageItemsType' => '\\StructType\\ImageItemsType',
            'ImageItem' => '\\StructType\\ImageItem',
            'ImageItemType' => '\\StructType\\ImageItemType',
            'ItemSearchCriterionType' => '\\StructType\\ItemSearchCriterionType',
            'Position' => '\\StructType\\Position',
            'RefPoint' => '\\StructType\\RefPoint',
            'CodeRef' => '\\StructType\\CodeRef',
            'HotelRef' => '\\StructType\\HotelRef',
            'Radius' => '\\StructType\\Radius',
            'MapArea' => '\\StructType\\MapArea',
            'LocationGeneralType' => '\\StructType\\LocationGeneralType',
            'LocationType' => '\\StructType\\LocationType',
            'MessageAcknowledgementType' => '\\StructType\\MessageAcknowledgementType',
            'MonetaryRuleType' => '\\StructType\\MonetaryRuleType',
            'MultimediaDescriptionsType' => '\\StructType\\MultimediaDescriptionsType',
            'MultimediaDescriptionType' => '\\StructType\\MultimediaDescriptionType',
            'OperatingAirlineType' => '\\StructType\\OperatingAirlineType',
            'OperationScheduleType' => '\\StructType\\OperationScheduleType',
            'OperationTimes' => '\\StructType\\OperationTimes',
            'OperationTime' => '\\StructType\\OperationTime',
            'OperationSchedulesType' => '\\StructType\\OperationSchedulesType',
            'OperationSchedulePlusChargeType' => '\\StructType\\OperationSchedulePlusChargeType',
            'OperationSchedulesPlusChargeType' => '\\StructType\\OperationSchedulesPlusChargeType',
            'OperationSchedule' => '\\StructType\\OperationSchedule',
            'OrdersType' => '\\StructType\\OrdersType',
            'Order' => '\\StructType\\Order',
            'Products' => '\\StructType\\Products',
            'Product' => '\\StructType\\Product',
            'OriginDestinationInformationType' => '\\StructType\\OriginDestinationInformationType',
            'OriginLocation' => '\\StructType\\OriginLocation',
            'DestinationLocation' => '\\StructType\\DestinationLocation',
            'POS_Type' => '\\StructType\\POS_Type',
            'ParagraphType' => '\\StructType\\ParagraphType',
            'ListItem' => '\\StructType\\ListItem',
            'PaymentCardType' => '\\StructType\\PaymentCardType',
            'CardIssuerName' => '\\StructType\\CardIssuerName',
            'SignatureOnFile' => '\\StructType\\SignatureOnFile',
            'MagneticStripe' => '\\StructType\\MagneticStripe',
            'PaymentDetailType' => '\\StructType\\PaymentDetailType',
            'PaymentAmount' => '\\StructType\\PaymentAmount',
            'PaymentFormType' => '\\StructType\\PaymentFormType',
            'Voucher' => '\\StructType\\Voucher',
            'LoyaltyRedemption' => '\\StructType\\LoyaltyRedemption',
            'LoyaltyCertificate' => '\\StructType\\LoyaltyCertificate',
            'MiscChargeOrder' => '\\StructType\\MiscChargeOrder',
            'Ticket' => '\\StructType\\Ticket',
            'ConjunctionTicketNbr' => '\\StructType\\ConjunctionTicketNbr',
            'Cash' => '\\StructType\\Cash',
            'PaymentRulesType' => '\\StructType\\PaymentRulesType',
            'PersonNameType' => '\\StructType\\PersonNameType',
            'RateQualifierType' => '\\StructType\\RateQualifierType',
            'RateComments' => '\\StructType\\RateComments',
            'RateComment' => '\\StructType\\RateComment',
            'RecipientInfosType' => '\\StructType\\RecipientInfosType',
            'RecipientInfo' => '\\StructType\\RecipientInfo',
            'ShippingInfo' => '\\StructType\\ShippingInfo',
            'Comments' => '\\StructType\\Comments',
            'ReferencePlaceHolderType' => '\\StructType\\ReferencePlaceHolderType',
            'RelatedTravelerType' => '\\StructType\\RelatedTravelerType',
            'RelativePositionType' => '\\StructType\\RelativePositionType',
            'RestaurantType' => '\\StructType\\RestaurantType',
            'MultimediaDescriptions' => '\\StructType\\MultimediaDescriptions',
            'InfoCodes' => '\\StructType\\InfoCodes',
            'InfoCode' => '\\StructType\\InfoCode',
            'CuisineCodes' => '\\StructType\\CuisineCodes',
            'CuisineCode' => '\\StructType\\CuisineCode',
            'SourceType' => '\\StructType\\SourceType',
            'RequestorID' => '\\StructType\\RequestorID',
            'BookingChannel' => '\\StructType\\BookingChannel',
            'SpecialRequestType' => '\\StructType\\SpecialRequestType',
            'SpecialRequest' => '\\StructType\\SpecialRequest',
            'StateProvType' => '\\StructType\\StateProvType',
            'StreetNmbrType' => '\\StructType\\StreetNmbrType',
            'SuccessType' => '\\StructType\\SuccessType',
            'TPA_ExtensionsType' => '\\StructType\\TPA_ExtensionsType',
            'TaxType' => '\\StructType\\TaxType',
            'TaxesType' => '\\StructType\\TaxesType',
            'TextDescriptionType' => '\\StructType\\TextDescriptionType',
            'TextItemsType' => '\\StructType\\TextItemsType',
            'TextItem' => '\\StructType\\TextItem',
            'TimeDurationType' => '\\StructType\\TimeDurationType',
            'TimeInstantType' => '\\StructType\\TimeInstantType',
            'TotalType' => '\\StructType\\TotalType',
            'TransportationsType' => '\\StructType\\TransportationsType',
            'TransportationType' => '\\StructType\\TransportationType',
            'Transportation' => '\\StructType\\Transportation',
            'TravelDateTimeType' => '\\StructType\\TravelDateTimeType',
            'TravelerRPHs' => '\\StructType\\TravelerRPHs',
            'TravelerRPH' => '\\StructType\\TravelerRPH',
            'URL_Type' => '\\StructType\\URL_Type',
            'UniqueID_Type' => '\\StructType\\UniqueID_Type',
            'VendorMessageType' => '\\StructType\\VendorMessageType',
            'VendorMessagesType' => '\\StructType\\VendorMessagesType',
            'VerificationType' => '\\StructType\\VerificationType',
            'PersonName' => '\\StructType\\PersonName',
            'TelephoneInfo' => '\\StructType\\TelephoneInfo',
            'ReservationTimeSpan' => '\\StructType\\ReservationTimeSpan',
            'AssociatedQuantity' => '\\StructType\\AssociatedQuantity',
            'StartLocation' => '\\StructType\\StartLocation',
            'EndLocation' => '\\StructType\\EndLocation',
            'VideoDescriptionType' => '\\StructType\\VideoDescriptionType',
            'VideoFormat' => '\\StructType\\VideoFormat',
            'VideoItemsType' => '\\StructType\\VideoItemsType',
            'VideoItem' => '\\StructType\\VideoItem',
            'VideoItemType' => '\\StructType\\VideoItemType',
            'WarningType' => '\\StructType\\WarningType',
            'WarningsType' => '\\StructType\\WarningsType',
            'WrittenConfInstType' => '\\StructType\\WrittenConfInstType',
            'AdvResTicketingType' => '\\StructType\\AdvResTicketingType',
            'AdvReservation' => '\\StructType\\AdvReservation',
            'AdvTicketing' => '\\StructType\\AdvTicketing',
            'AirFeeType' => '\\StructType\\AirFeeType',
            'AirItineraryPricingInfoType' => '\\StructType\\AirItineraryPricingInfoType',
            'ItinTotalFare' => '\\StructType\\ItinTotalFare',
            'PTC_FareBreakdowns' => '\\StructType\\PTC_FareBreakdowns',
            'FareInfos' => '\\StructType\\FareInfos',
            'FareInfo' => '\\StructType\\FareInfo',
            'AirItineraryType' => '\\StructType\\AirItineraryType',
            'OriginDestinationOptions' => '\\StructType\\OriginDestinationOptions',
            'OriginDestinationOption' => '\\StructType\\OriginDestinationOption',
            'AirReservationType' => '\\StructType\\AirReservationType',
            'Queues' => '\\StructType\\Queues',
            'Queue' => '\\StructType\\Queue',
            'BookingReferenceID' => '\\StructType\\BookingReferenceID',
            'PricingOverview' => '\\StructType\\PricingOverview',
            'PricingIndicator' => '\\StructType\\PricingIndicator',
            'Account' => '\\StructType\\Account',
            'AirTaxType' => '\\StructType\\AirTaxType',
            'AirTravelerType' => '\\StructType\\AirTravelerType',
            'ProfileRef' => '\\StructType\\ProfileRef',
            'Document' => '\\StructType\\Document',
            'TravelerRefNumber' => '\\StructType\\TravelerRefNumber',
            'FlightSegmentRPHs' => '\\StructType\\FlightSegmentRPHs',
            'AuthorizationType' => '\\StructType\\AuthorizationType',
            'CheckAuthorization' => '\\StructType\\CheckAuthorization',
            'CreditCardAuthorization' => '\\StructType\\CreditCardAuthorization',
            'AccountAuthorization' => '\\StructType\\AccountAuthorization',
            'AccountInfo' => '\\StructType\\AccountInfo',
            'BookFlightSegmentType' => '\\StructType\\BookFlightSegmentType',
            'BookingClassAvails' => '\\StructType\\BookingClassAvails',
            'BookingClassAvail' => '\\StructType\\BookingClassAvail',
            'StopLocation' => '\\StructType\\StopLocation',
            'BookingPriceInfoType' => '\\StructType\\BookingPriceInfoType',
            'CabinAvailabilityType' => '\\StructType\\CabinAvailabilityType',
            'Meal' => '\\StructType\\Meal',
            'BaggageAllowance' => '\\StructType\\BaggageAllowance',
            'CabinClassType' => '\\StructType\\CabinClassType',
            'AirRows' => '\\StructType\\AirRows',
            'FareBasisCodeType' => '\\StructType\\FareBasisCodeType',
            'FareInfoType' => '\\StructType\\FareInfoType',
            'FareReference' => '\\StructType\\FareReference',
            'RuleInfo' => '\\StructType\\RuleInfo',
            'Date' => '\\StructType\\Date',
            'Fare' => '\\StructType\\Fare',
            'PTC' => '\\StructType\\PTC',
            'DiscountPricing' => '\\StructType\\DiscountPricing',
            'City' => '\\StructType\\City',
            'Airport' => '\\StructType\\Airport',
            'FareType' => '\\StructType\\FareType',
            'BaseFare' => '\\StructType\\BaseFare',
            'EquivFare' => '\\StructType\\EquivFare',
            'Taxes' => '\\StructType\\Taxes',
            'Fees' => '\\StructType\\Fees',
            'TotalFare' => '\\StructType\\TotalFare',
            'FareConstruction' => '\\StructType\\FareConstruction',
            'UnstructuredFareCalc' => '\\StructType\\UnstructuredFareCalc',
            'FareBaggageAllowance' => '\\StructType\\FareBaggageAllowance',
            'TourCode' => '\\StructType\\TourCode',
            'Remark' => '\\StructType\\Remark',
            'OriginalIssueInfo' => '\\StructType\\OriginalIssueInfo',
            'ExchangeInfo' => '\\StructType\\ExchangeInfo',
            'CouponInfo' => '\\StructType\\CouponInfo',
            'OriginalOriginDestination' => '\\StructType\\OriginalOriginDestination',
            'Discounts' => '\\StructType\\Discounts',
            'Discount' => '\\StructType\\Discount',
            'FlightLegType' => '\\StructType\\FlightLegType',
            'FlightSegmentType' => '\\StructType\\FlightSegmentType',
            'MarketingAirline' => '\\StructType\\MarketingAirline',
            'FulfillmentType' => '\\StructType\\FulfillmentType',
            'PaymentDetails' => '\\StructType\\PaymentDetails',
            'PaymentDetail' => '\\StructType\\PaymentDetail',
            'Receipt' => '\\StructType\\Receipt',
            'PaymentText' => '\\StructType\\PaymentText',
            'MarketingCabinType' => '\\StructType\\MarketingCabinType',
            'OriginDestinationOptionType' => '\\StructType\\OriginDestinationOptionType',
            'FlightSegment' => '\\StructType\\FlightSegment',
            'OtherServiceInfoType' => '\\StructType\\OtherServiceInfoType',
            'PassengerTypeQuantityType' => '\\StructType\\PassengerTypeQuantityType',
            'PriceRequestInformationType' => '\\StructType\\PriceRequestInformationType',
            'NegotiatedFareCode' => '\\StructType\\NegotiatedFareCode',
            'RebookOption' => '\\StructType\\RebookOption',
            'PricedItinerariesType' => '\\StructType\\PricedItinerariesType',
            'PricedItinerary' => '\\StructType\\PricedItinerary',
            'PricedItineraryType' => '\\StructType\\PricedItineraryType',
            'AirItineraryPricingInfo' => '\\StructType\\AirItineraryPricingInfo',
            'TicketingInfo' => '\\StructType\\TicketingInfo',
            'DeliveryInfo' => '\\StructType\\DeliveryInfo',
            'PTCFareBreakdownType' => '\\StructType\\PTCFareBreakdownType',
            'FareBasisCodes' => '\\StructType\\FareBasisCodes',
            'PassengerFare' => '\\StructType\\PassengerFare',
            'TicketFeeDetail' => '\\StructType\\TicketFeeDetail',
            'Fee' => '\\StructType\\Fee',
            'BaseFee' => '\\StructType\\BaseFee',
            'Total' => '\\StructType\\Total',
            'TicketDesignators' => '\\StructType\\TicketDesignators',
            'TicketDesignator' => '\\StructType\\TicketDesignator',
            'Endorsements' => '\\StructType\\Endorsements',
            'Endorsement' => '\\StructType\\Endorsement',
            'PricingUnit' => '\\StructType\\PricingUnit',
            'FareComponent' => '\\StructType\\FareComponent',
            'FlightLeg' => '\\StructType\\FlightLeg',
            'RowDetailsType' => '\\StructType\\RowDetailsType',
            'AirSeats' => '\\StructType\\AirSeats',
            'AirSeat' => '\\StructType\\AirSeat',
            'AirRowCharacteristics' => '\\StructType\\AirRowCharacteristics',
            'RuleInfoType' => '\\StructType\\RuleInfoType',
            'ResTicketingRules' => '\\StructType\\ResTicketingRules',
            'AdvResTicketing' => '\\StructType\\AdvResTicketing',
            'ChargesRules' => '\\StructType\\ChargesRules',
            'SeatMapDetailsType' => '\\StructType\\SeatMapDetailsType',
            'CabinClass' => '\\StructType\\CabinClass',
            'SeatRequestType' => '\\StructType\\SeatRequestType',
            'SpecialRemarkType' => '\\StructType\\SpecialRemarkType',
            'FlightRefNumber' => '\\StructType\\FlightRefNumber',
            'AuthorizedViewers' => '\\StructType\\AuthorizedViewers',
            'AuthorizedViewer' => '\\StructType\\AuthorizedViewer',
            'SpecialReqDetailsType' => '\\StructType\\SpecialReqDetailsType',
            'SeatRequests' => '\\StructType\\SeatRequests',
            'SeatRequest' => '\\StructType\\SeatRequest',
            'SpecialServiceRequests' => '\\StructType\\SpecialServiceRequests',
            'SpecialServiceRequest' => '\\StructType\\SpecialServiceRequest',
            'OtherServiceInformations' => '\\StructType\\OtherServiceInformations',
            'OtherServiceInformation' => '\\StructType\\OtherServiceInformation',
            'Remarks' => '\\StructType\\Remarks',
            'SpecialRemarks' => '\\StructType\\SpecialRemarks',
            'SpecialRemark' => '\\StructType\\SpecialRemark',
            'SpecialServiceRequestType' => '\\StructType\\SpecialServiceRequestType',
            'SpecificFlightInfoType' => '\\StructType\\SpecificFlightInfoType',
            'BookingClassPref' => '\\StructType\\BookingClassPref',
            'StayRestrictionsType' => '\\StructType\\StayRestrictionsType',
            'MinimumStay' => '\\StructType\\MinimumStay',
            'MaximumStay' => '\\StructType\\MaximumStay',
            'TicketingInfoRS_Type' => '\\StructType\\TicketingInfoRS_Type',
            'TicketingInfoType' => '\\StructType\\TicketingInfoType',
            'TicketAdvisory' => '\\StructType\\TicketAdvisory',
            'TicketingVendor' => '\\StructType\\TicketingVendor',
            'PricingSystem' => '\\StructType\\PricingSystem',
            'TravelerInformationType' => '\\StructType\\TravelerInformationType',
            'TravelerInfoSummaryType' => '\\StructType\\TravelerInfoSummaryType',
            'PriceRequestInformation' => '\\StructType\\PriceRequestInformation',
            'FareRestrictionPref' => '\\StructType\\FareRestrictionPref',
            'FlightReference' => '\\StructType\\FlightReference',
            'SegmentOverride' => '\\StructType\\SegmentOverride',
            'LocationRequirement' => '\\StructType\\LocationRequirement',
            'TravelerInfoType' => '\\StructType\\TravelerInfoType',
            'AirTraveler' => '\\StructType\\AirTraveler',
            'VoluntaryChangesType' => '\\StructType\\VoluntaryChangesType',
            'Penalty' => '\\StructType\\Penalty',
            'AddressPrefType' => '\\StructType\\AddressPrefType',
            'CommonPrefType' => '\\StructType\\CommonPrefType',
            'ContactPref' => '\\StructType\\ContactPref',
            'CompanyNamePrefType' => '\\StructType\\CompanyNamePrefType',
            'InsurancePrefType' => '\\StructType\\InsurancePrefType',
            'InterestPrefType' => '\\StructType\\InterestPrefType',
            'LoyaltyPrefType' => '\\StructType\\LoyaltyPrefType',
            'MealPrefType' => '\\StructType\\MealPrefType',
            'MediaEntertainPrefType' => '\\StructType\\MediaEntertainPrefType',
            'NamePrefType' => '\\StructType\\NamePrefType',
            'OtherSrvcPrefType' => '\\StructType\\OtherSrvcPrefType',
            'PaymentFormPrefType' => '\\StructType\\PaymentFormPrefType',
            'PetInfoPrefType' => '\\StructType\\PetInfoPrefType',
            'PhonePrefType' => '\\StructType\\PhonePrefType',
            'RelatedTravelerPrefType' => '\\StructType\\RelatedTravelerPrefType',
            'SeatingPrefType' => '\\StructType\\SeatingPrefType',
            'SpecRequestPrefType' => '\\StructType\\SpecRequestPrefType',
            'TicketDistribPrefType' => '\\StructType\\TicketDistribPrefType',
            'AirlinePrefType' => '\\StructType\\AirlinePrefType',
            'VendorPref' => '\\StructType\\VendorPref',
            'FareRestrictPref' => '\\StructType\\FareRestrictPref',
            'FarePref' => '\\StructType\\FarePref',
            'TourCodePref' => '\\StructType\\TourCodePref',
            'TourCodeInfo' => '\\StructType\\TourCodeInfo',
            'StaffTourCodeInfo' => '\\StructType\\StaffTourCodeInfo',
            'FlightTypePref' => '\\StructType\\FlightTypePref',
            'CabinPref' => '\\StructType\\CabinPref',
            'SeatPref' => '\\StructType\\SeatPref',
            'SSR_Pref' => '\\StructType\\SSR_Pref',
            'AccountInformation' => '\\StructType\\AccountInformation',
            'TaxRegistrationDetails' => '\\StructType\\TaxRegistrationDetails',
            'KeywordPref' => '\\StructType\\KeywordPref',
            'AirportPrefType' => '\\StructType\\AirportPrefType',
            'AirSearchPrefsType' => '\\StructType\\AirSearchPrefsType',
            'TicketDistribPref' => '\\StructType\\TicketDistribPref',
            'BookingSeatPref' => '\\StructType\\BookingSeatPref',
            'EquipmentTypePref' => '\\StructType\\EquipmentTypePref',
            'BedTypePrefType' => '\\StructType\\BedTypePrefType',
            'BusinessSrvcPrefType' => '\\StructType\\BusinessSrvcPrefType',
            'FoodSrvcPrefType' => '\\StructType\\FoodSrvcPrefType',
            'HotelPrefType' => '\\StructType\\HotelPrefType',
            'PersonalSrvcPrefType' => '\\StructType\\PersonalSrvcPrefType',
            'PhysChallFeaturePrefType' => '\\StructType\\PhysChallFeaturePrefType',
            'PropertyAmenityPrefType' => '\\StructType\\PropertyAmenityPrefType',
            'PropertyClassPrefType' => '\\StructType\\PropertyClassPrefType',
            'PropertyLocationPrefType' => '\\StructType\\PropertyLocationPrefType',
            'PropertyNamePrefType' => '\\StructType\\PropertyNamePrefType',
            'PropertyTypePrefType' => '\\StructType\\PropertyTypePrefType',
            'RecreationSrvcPrefType' => '\\StructType\\RecreationSrvcPrefType',
            'RoomAmenityPrefType' => '\\StructType\\RoomAmenityPrefType',
            'RoomLocationPrefType' => '\\StructType\\RoomLocationPrefType',
            'SecurityFeaturePrefType' => '\\StructType\\SecurityFeaturePrefType',
            'CoverageDetailsType' => '\\StructType\\CoverageDetailsType',
            'CoveragePricedType' => '\\StructType\\CoveragePricedType',
            'CoverageType' => '\\StructType\\CoverageType',
            'CustomerPrimaryAdditionalType' => '\\StructType\\CustomerPrimaryAdditionalType',
            'Primary' => '\\StructType\\Primary',
            'Additional' => '\\StructType\\Additional',
            'OffLocationServiceCoreType' => '\\StructType\\OffLocationServiceCoreType',
            'OffLocationServicePricedType' => '\\StructType\\OffLocationServicePricedType',
            'OffLocationServiceType' => '\\StructType\\OffLocationServiceType',
            'RateRulesType' => '\\StructType\\RateRulesType',
            'AdvanceBooking' => '\\StructType\\AdvanceBooking',
            'PickupReturnRules' => '\\StructType\\PickupReturnRules',
            'EarliestPickup' => '\\StructType\\EarliestPickup',
            'LatestPickup' => '\\StructType\\LatestPickup',
            'LatestReturn' => '\\StructType\\LatestReturn',
            'EarliestReturn' => '\\StructType\\EarliestReturn',
            'RateGuarantee' => '\\StructType\\RateGuarantee',
            'PaymentRules' => '\\StructType\\PaymentRules',
            'AcceptablePayments' => '\\StructType\\AcceptablePayments',
            'AcceptablePayment' => '\\StructType\\AcceptablePayment',
            'CancelPenaltyInfo' => '\\StructType\\CancelPenaltyInfo',
            'Deadline' => '\\StructType\\Deadline',
            'PenaltyFee' => '\\StructType\\PenaltyFee',
            'RateDeposit' => '\\StructType\\RateDeposit',
            'VehicleAdditionalDriverRequirementsType' => '\\StructType\\VehicleAdditionalDriverRequirementsType',
            'AddlDriverInfos' => '\\StructType\\AddlDriverInfos',
            'AddlDriverInfo' => '\\StructType\\AddlDriverInfo',
            'Vehicles' => '\\StructType\\Vehicles',
            'Vehicle' => '\\StructType\\Vehicle',
            'VehicleAgeRequirementsType' => '\\StructType\\VehicleAgeRequirementsType',
            'Age' => '\\StructType\\Age',
            'AgeSurcharge' => '\\StructType\\AgeSurcharge',
            'AgeInfos' => '\\StructType\\AgeInfos',
            'AgeInfo' => '\\StructType\\AgeInfo',
            'VehicleArrivalDetailsType' => '\\StructType\\VehicleArrivalDetailsType',
            'VehicleAvailAdditionalInfoType' => '\\StructType\\VehicleAvailAdditionalInfoType',
            'PricedCoverages' => '\\StructType\\PricedCoverages',
            'VehicleAvailCoreType' => '\\StructType\\VehicleAvailCoreType',
            'TotalCharge' => '\\StructType\\TotalCharge',
            'PricedEquips' => '\\StructType\\PricedEquips',
            'Reference' => '\\StructType\\Reference',
            'Vendor' => '\\StructType\\Vendor',
            'VendorLocation' => '\\StructType\\VendorLocation',
            'DropOffLocation' => '\\StructType\\DropOffLocation',
            'VehicleAvailRQAdditionalInfoType' => '\\StructType\\VehicleAvailRQAdditionalInfoType',
            'CoveragePrefs' => '\\StructType\\CoveragePrefs',
            'CoveragePref' => '\\StructType\\CoveragePref',
            'VehicleAvailRQCoreType' => '\\StructType\\VehicleAvailRQCoreType',
            'VendorPrefs' => '\\StructType\\VendorPrefs',
            'VehPrefs' => '\\StructType\\VehPrefs',
            'VehPref' => '\\StructType\\VehPref',
            'DriverType' => '\\StructType\\DriverType',
            'RateQualifier' => '\\StructType\\RateQualifier',
            'RateRange' => '\\StructType\\RateRange',
            'SpecialEquipPrefs' => '\\StructType\\SpecialEquipPrefs',
            'SpecialEquipPref' => '\\StructType\\SpecialEquipPref',
            'VehicleAvailRSAdditionalInfoType' => '\\StructType\\VehicleAvailRSAdditionalInfoType',
            'VehicleAvailRSCoreType' => '\\StructType\\VehicleAvailRSCoreType',
            'VehVendorAvails' => '\\StructType\\VehVendorAvails',
            'VehicleAvailVendorInfoType' => '\\StructType\\VehicleAvailVendorInfoType',
            'TourInfo' => '\\StructType\\TourInfo',
            'VehicleChargePurposeType' => '\\StructType\\VehicleChargePurposeType',
            'VehicleChargeType' => '\\StructType\\VehicleChargeType',
            'TaxAmounts' => '\\StructType\\TaxAmounts',
            'TaxAmount' => '\\StructType\\TaxAmount',
            'MinMax' => '\\StructType\\MinMax',
            'Calculation' => '\\StructType\\Calculation',
            'VehicleCoreType' => '\\StructType\\VehicleCoreType',
            'VehType' => '\\StructType\\VehType',
            'VehClass' => '\\StructType\\VehClass',
            'VehicleEquipmentPricedType' => '\\StructType\\VehicleEquipmentPricedType',
            'VehicleEquipmentType' => '\\StructType\\VehicleEquipmentType',
            'VehicleLocationAdditionalDetailsType' => '\\StructType\\VehicleLocationAdditionalDetailsType',
            'VehRentLocInfos' => '\\StructType\\VehRentLocInfos',
            'Shuttle' => '\\StructType\\Shuttle',
            'ShuttleInfos' => '\\StructType\\ShuttleInfos',
            'ShuttleInfo' => '\\StructType\\ShuttleInfo',
            'OneWayDropLocations' => '\\StructType\\OneWayDropLocations',
            'OneWayDropLocation' => '\\StructType\\OneWayDropLocation',
            'VehicleLocationAdditionalFeesType' => '\\StructType\\VehicleLocationAdditionalFeesType',
            'Tax' => '\\StructType\\Tax',
            'Surcharges' => '\\StructType\\Surcharges',
            'Surcharge' => '\\StructType\\Surcharge',
            'MiscellaneousCharges' => '\\StructType\\MiscellaneousCharges',
            'MiscellaneousCharge' => '\\StructType\\MiscellaneousCharge',
            'VehicleLocationDetailsType' => '\\StructType\\VehicleLocationDetailsType',
            'VehicleLocationInformationType' => '\\StructType\\VehicleLocationInformationType',
            'VehicleLocationLiabilitiesType' => '\\StructType\\VehicleLocationLiabilitiesType',
            'Coverages' => '\\StructType\\Coverages',
            'Coverage' => '\\StructType\\Coverage',
            'CoverageFees' => '\\StructType\\CoverageFees',
            'CoverageFee' => '\\StructType\\CoverageFee',
            'VehicleLocationVehiclesType' => '\\StructType\\VehicleLocationVehiclesType',
            'VehicleInfos' => '\\StructType\\VehicleInfos',
            'VehicleInfo' => '\\StructType\\VehicleInfo',
            'VehiclePrefType' => '\\StructType\\VehiclePrefType',
            'VehMakeModel' => '\\StructType\\VehMakeModel',
            'VehicleProfileRentalPrefType' => '\\StructType\\VehicleProfileRentalPrefType',
            'LoyaltyPref' => '\\StructType\\LoyaltyPref',
            'PaymentFormPref' => '\\StructType\\PaymentFormPref',
            'VehicleRentalCoreType' => '\\StructType\\VehicleRentalCoreType',
            'PickUpLocation' => '\\StructType\\PickUpLocation',
            'ReturnLocation' => '\\StructType\\ReturnLocation',
            'VehicleRentalDetailsType' => '\\StructType\\VehicleRentalDetailsType',
            'FuelLevelDetails' => '\\StructType\\FuelLevelDetails',
            'OdometerReading' => '\\StructType\\OdometerReading',
            'ConditionReport' => '\\StructType\\ConditionReport',
            'VehicleRentalRateType' => '\\StructType\\VehicleRentalRateType',
            'RateDistance' => '\\StructType\\RateDistance',
            'VehicleCharges' => '\\StructType\\VehicleCharges',
            'RateRestrictions' => '\\StructType\\RateRestrictions',
            'PickupReturnRule' => '\\StructType\\PickupReturnRule',
            'VehicleRentalTransactionType' => '\\StructType\\VehicleRentalTransactionType',
            'PickUpReturnDetails' => '\\StructType\\PickUpReturnDetails',
            'PricedEquip' => '\\StructType\\PricedEquip',
            'Equipment' => '\\StructType\\Equipment',
            'VehicleReservationRQAdditionalInfoType' => '\\StructType\\VehicleReservationRQAdditionalInfoType',
            'RentalPaymentPref' => '\\StructType\\RentalPaymentPref',
            'VehicleReservationRQCoreType' => '\\StructType\\VehicleReservationRQCoreType',
            'VehicleReservationSummaryType' => '\\StructType\\VehicleReservationSummaryType',
            'ConfID' => '\\StructType\\ConfID',
            'VehicleReservationType' => '\\StructType\\VehicleReservationType',
            'VehSegmentCore' => '\\StructType\\VehSegmentCore',
            'VehicleSegmentAdditionalInfoType' => '\\StructType\\VehicleSegmentAdditionalInfoType',
            'VendorMessages' => '\\StructType\\VendorMessages',
            'VehicleSegmentCoreType' => '\\StructType\\VehicleSegmentCoreType',
            'VehicleSpecialReqPrefType' => '\\StructType\\VehicleSpecialReqPrefType',
            'VehicleTourInfoType' => '\\StructType\\VehicleTourInfoType',
            'VehicleType' => '\\StructType\\VehicleType',
            'VehIdentity' => '\\StructType\\VehIdentity',
            'VehicleVendorAvailabilityType' => '\\StructType\\VehicleVendorAvailabilityType',
            'VehAvails' => '\\StructType\\VehAvails',
            'VehAvail' => '\\StructType\\VehAvail',
            'VehicleWhereAtFacilityType' => '\\StructType\\VehicleWhereAtFacilityType',
            'DeductibleType' => '\\StructType\\DeductibleType',
            'VehicleResRSAdditionalInfoType' => '\\StructType\\VehicleResRSAdditionalInfoType',
            'VehicleResRSCoreType' => '\\StructType\\VehicleResRSCoreType',
            'AccessesType' => '\\StructType\\AccessesType',
            'Access' => '\\StructType\\Access',
            'AffiliationsType' => '\\StructType\\AffiliationsType',
            'AgreementsType' => '\\StructType\\AgreementsType',
            'ProfileSecurity' => '\\StructType\\ProfileSecurity',
            'AllianceConsortiumType' => '\\StructType\\AllianceConsortiumType',
            'AllianceMember' => '\\StructType\\AllianceMember',
            'CertificationType' => '\\StructType\\CertificationType',
            'CommissionInfoType' => '\\StructType\\CommissionInfoType',
            'CompanyInfoType' => '\\StructType\\CompanyInfoType',
            'AddressInfo' => '\\StructType\\AddressInfo',
            'TripPurpose' => '\\StructType\\TripPurpose',
            'EmployerType' => '\\StructType\\EmployerType',
            'InsuranceType' => '\\StructType\\InsuranceType',
            'LoyaltyProgramType' => '\\StructType\\LoyaltyProgramType',
            'OrganizationType' => '\\StructType\\OrganizationType',
            'OrgMemberName' => '\\StructType\\OrgMemberName',
            'PreferencesType' => '\\StructType\\PreferencesType',
            'PrefCollection' => '\\StructType\\PrefCollection',
            'ProfileType' => '\\StructType\\ProfileType',
            'UserID' => '\\StructType\\UserID',
            'ProfilesType' => '\\StructType\\ProfilesType',
            'ProfileInfo' => '\\StructType\\ProfileInfo',
            'TravelArrangerType' => '\\StructType\\TravelArrangerType',
            'TravelClubType' => '\\StructType\\TravelClubType',
            'ClubMemberName' => '\\StructType\\ClubMemberName',
            'FolioIDsType' => '\\StructType\\FolioIDsType',
            'HotelResModifyRequestType' => '\\StructType\\HotelResModifyRequestType',
            'HotelResModifyResponseType' => '\\StructType\\HotelResModifyResponseType',
            'HotelResModifyType' => '\\StructType\\HotelResModifyType',
            'HotelResModify' => '\\StructType\\HotelResModify',
            'Verification' => '\\StructType\\Verification',
            'HotelReservationType' => '\\StructType\\HotelReservationType',
            'HotelReservationsType' => '\\StructType\\HotelReservationsType',
            'HotelResRequestType' => '\\StructType\\HotelResRequestType',
            'HotelResResponseType' => '\\StructType\\HotelResResponseType',
            'LoyaltyPointsAccrualsType' => '\\StructType\\LoyaltyPointsAccrualsType',
            'SelectedLoyalty' => '\\StructType\\SelectedLoyalty',
            'ResCommonDetailType' => '\\StructType\\ResCommonDetailType',
            'TimeSpan' => '\\StructType\\TimeSpan',
            'ResGlobalInfoType' => '\\StructType\\ResGlobalInfoType',
            'ResGuestRPHsType' => '\\StructType\\ResGuestRPHsType',
            'ResGuestRPH' => '\\StructType\\ResGuestRPH',
            'ResGuestType' => '\\StructType\\ResGuestType',
            'ProfileRPHs' => '\\StructType\\ProfileRPHs',
            'ProfileRPH' => '\\StructType\\ProfileRPH',
            'ResGuestsType' => '\\StructType\\ResGuestsType',
            'RevenueCategoriesType' => '\\StructType\\RevenueCategoriesType',
            'RevenueCategoryType' => '\\StructType\\RevenueCategoryType',
            'SummaryAmount' => '\\StructType\\SummaryAmount',
            'RevenueDetailsType' => '\\StructType\\RevenueDetailsType',
            'RevenueDetailType' => '\\StructType\\RevenueDetailType',
            'RoomStaysType' => '\\StructType\\RoomStaysType',
            'RoomStay' => '\\StructType\\RoomStay',
            'ServiceRPHsType' => '\\StructType\\ServiceRPHsType',
            'ServiceRPH' => '\\StructType\\ServiceRPH',
            'ServicesType' => '\\StructType\\ServicesType',
            'ServiceType' => '\\StructType\\ServiceType',
            'StayInfosType' => '\\StructType\\StayInfosType',
            'StayInfoType' => '\\StructType\\StayInfoType',
            'TransportInfoType' => '\\StructType\\TransportInfoType',
            'TransportInfo' => '\\StructType\\TransportInfo',
            'AddressesType' => '\\StructType\\AddressesType',
            'AdditionalDetailType' => '\\StructType\\AdditionalDetailType',
            'AdditionalDetailsType' => '\\StructType\\AdditionalDetailsType',
            'AdditionalGuestAmountType' => '\\StructType\\AdditionalGuestAmountType',
            'AdjustmentsType' => '\\StructType\\AdjustmentsType',
            'Adjustment' => '\\StructType\\Adjustment',
            'AmountLiteType' => '\\StructType\\AmountLiteType',
            'AmountPercentType' => '\\StructType\\AmountPercentType',
            'AmountType' => '\\StructType\\AmountType',
            'AdditionalGuestAmounts' => '\\StructType\\AdditionalGuestAmounts',
            'AreasType' => '\\StructType\\AreasType',
            'Area' => '\\StructType\\Area',
            'AvailStatusMessageType' => '\\StructType\\AvailStatusMessageType',
            'BestAvailableRates' => '\\StructType\\BestAvailableRates',
            'BestAvailableRate' => '\\StructType\\BestAvailableRate',
            'HurdleRate' => '\\StructType\\HurdleRate',
            'Delta' => '\\StructType\\Delta',
            'RestrictionStatus' => '\\StructType\\RestrictionStatus',
            'BaseInvCountType' => '\\StructType\\BaseInvCountType',
            'InvCounts' => '\\StructType\\InvCounts',
            'InvCount' => '\\StructType\\InvCount',
            'InvBlockCutoff' => '\\StructType\\InvBlockCutoff',
            'OffSell' => '\\StructType\\OffSell',
            'BasicPropertyInfoType' => '\\StructType\\BasicPropertyInfoType',
            'ContactNumbers' => '\\StructType\\ContactNumbers',
            'ContactNumber' => '\\StructType\\ContactNumber',
            'Award' => '\\StructType\\Award',
            'HotelAmenity' => '\\StructType\\HotelAmenity',
            'Recreation' => '\\StructType\\Recreation',
            'Service' => '\\StructType\\Service',
            'Policy' => '\\StructType\\Policy',
            'BookingRulesType' => '\\StructType\\BookingRulesType',
            'BookingRule' => '\\StructType\\BookingRule',
            'AcceptableGuarantees' => '\\StructType\\AcceptableGuarantees',
            'AcceptableGuarantee' => '\\StructType\\AcceptableGuarantee',
            'AddtionalRules' => '\\StructType\\AddtionalRules',
            'AdditionalRule' => '\\StructType\\AdditionalRule',
            'CheckoutCharge' => '\\StructType\\CheckoutCharge',
            'CancelPenaltiesType' => '\\StructType\\CancelPenaltiesType',
            'CancelPenaltyType' => '\\StructType\\CancelPenaltyType',
            'DestinationSystemCodesType' => '\\StructType\\DestinationSystemCodesType',
            'DestinationSystemCode' => '\\StructType\\DestinationSystemCode',
            'DiscountType' => '\\StructType\\DiscountType',
            'DOW_RestrictionsType' => '\\StructType\\DOW_RestrictionsType',
            'AvailableDaysOfWeek' => '\\StructType\\AvailableDaysOfWeek',
            'ArrivalDaysOfWeek' => '\\StructType\\ArrivalDaysOfWeek',
            'DepartureDaysOfWeek' => '\\StructType\\DepartureDaysOfWeek',
            'RequiredDaysOfWeek' => '\\StructType\\RequiredDaysOfWeek',
            'DOW_RulesType' => '\\StructType\\DOW_RulesType',
            'FeaturesType' => '\\StructType\\FeaturesType',
            'Feature' => '\\StructType\\Feature',
            'Charge' => '\\StructType\\Charge',
            'GDS_InfoType' => '\\StructType\\GDS_InfoType',
            'GDS_Codes' => '\\StructType\\GDS_Codes',
            'GDS_Code' => '\\StructType\\GDS_Code',
            'GDS_CodeDetails' => '\\StructType\\GDS_CodeDetails',
            'GDS_CodeDetail' => '\\StructType\\GDS_CodeDetail',
            'GuaranteeType' => '\\StructType\\GuaranteeType',
            'GuaranteesAccepted' => '\\StructType\\GuaranteesAccepted',
            'GuaranteeAccepted' => '\\StructType\\GuaranteeAccepted',
            'GuestCountType' => '\\StructType\\GuestCountType',
            'GuestCount' => '\\StructType\\GuestCount',
            'GuestRoomType' => '\\StructType\\GuestRoomType',
            'Quantities' => '\\StructType\\Quantities',
            'Occupancy' => '\\StructType\\Occupancy',
            'Room' => '\\StructType\\Room',
            'Amenities' => '\\StructType\\Amenities',
            'Amenity' => '\\StructType\\Amenity',
            'RoomLevelFees' => '\\StructType\\RoomLevelFees',
            'HotelAdditionalChargesType' => '\\StructType\\HotelAdditionalChargesType',
            'AdditionalCharge' => '\\StructType\\AdditionalCharge',
            'HotelPaymentFormType' => '\\StructType\\HotelPaymentFormType',
            'MasterAccountUsage' => '\\StructType\\MasterAccountUsage',
            'HotelReservationIDsType' => '\\StructType\\HotelReservationIDsType',
            'HotelReservationID' => '\\StructType\\HotelReservationID',
            'HotelRoomListType' => '\\StructType\\HotelRoomListType',
            'Guests' => '\\StructType\\Guests',
            'Guest' => '\\StructType\\Guest',
            'Loyalty' => '\\StructType\\Loyalty',
            'GuaranteePayment' => '\\StructType\\GuaranteePayment',
            'MasterContact' => '\\StructType\\MasterContact',
            'UniqueIDs' => '\\StructType\\UniqueIDs',
            'MasterAccount' => '\\StructType\\MasterAccount',
            'RoomStays' => '\\StructType\\RoomStays',
            'Event' => '\\StructType\\Event',
            'HotelSearchCriteriaType' => '\\StructType\\HotelSearchCriteriaType',
            'Criterion' => '\\StructType\\Criterion',
            'HotelSearchCriterionType' => '\\StructType\\HotelSearchCriterionType',
            'HotelFeature' => '\\StructType\\HotelFeature',
            'RoomStayCandidates' => '\\StructType\\RoomStayCandidates',
            'Media' => '\\StructType\\Media',
            'HotelMeetingFacility' => '\\StructType\\HotelMeetingFacility',
            'MealPlan' => '\\StructType\\MealPlan',
            'InvBlockRoomType' => '\\StructType\\InvBlockRoomType',
            'RoomTypeAllocations' => '\\StructType\\RoomTypeAllocations',
            'RoomTypeAllocation' => '\\StructType\\RoomTypeAllocation',
            'RatePlans' => '\\StructType\\RatePlans',
            'RatePlan' => '\\StructType\\RatePlan',
            'MarketCode' => '\\StructType\\MarketCode',
            'MethodInfo' => '\\StructType\\MethodInfo',
            'DaysOfWeeks' => '\\StructType\\DaysOfWeeks',
            'InvBlockType' => '\\StructType\\InvBlockType',
            'InvBlockDates' => '\\StructType\\InvBlockDates',
            'RoomTypes' => '\\StructType\\RoomTypes',
            'BlockDescriptions' => '\\StructType\\BlockDescriptions',
            'BlockDescription' => '\\StructType\\BlockDescription',
            'Contacts' => '\\StructType\\Contacts',
            'InvCountType' => '\\StructType\\InvCountType',
            'LengthsOfStayType' => '\\StructType\\LengthsOfStayType',
            'LengthOfStay' => '\\StructType\\LengthOfStay',
            'LOS_Pattern' => '\\StructType\\LOS_Pattern',
            'MeetingRoomCapacityType' => '\\StructType\\MeetingRoomCapacityType',
            'MeetingRoomCodeType' => '\\StructType\\MeetingRoomCodeType',
            'MeetingRoomsType' => '\\StructType\\MeetingRoomsType',
            'MeetingRoom' => '\\StructType\\MeetingRoom',
            'Codes' => '\\StructType\\Codes',
            'Dimension' => '\\StructType\\Dimension',
            'AvailableCapacities' => '\\StructType\\AvailableCapacities',
            'MembershipType' => '\\StructType\\MembershipType',
            'Membership' => '\\StructType\\Membership',
            'MessageType' => '\\StructType\\MessageType',
            'OriginalPayloadStdAttributes' => '\\StructType\\OriginalPayloadStdAttributes',
            'ProductDescriptionsType' => '\\StructType\\ProductDescriptionsType',
            'ProductDescription' => '\\StructType\\ProductDescription',
            'PropertyValueMatchType' => '\\StructType\\PropertyValueMatchType',
            'SearchValueMatch' => '\\StructType\\SearchValueMatch',
            'RateAmountMessageType' => '\\StructType\\RateAmountMessageType',
            'Rates' => '\\StructType\\Rates',
            'Rate' => '\\StructType\\Rate',
            'RateLiteType' => '\\StructType\\RateLiteType',
            'RatePlanCandidatesType' => '\\StructType\\RatePlanCandidatesType',
            'RatePlanCandidate' => '\\StructType\\RatePlanCandidate',
            'HotelRefs' => '\\StructType\\HotelRefs',
            'MealsIncluded' => '\\StructType\\MealsIncluded',
            'ArrivalPolicy' => '\\StructType\\ArrivalPolicy',
            'RatePlanCommission' => '\\StructType\\RatePlanCommission',
            'RatePlanLiteType' => '\\StructType\\RatePlanLiteType',
            'RatePlanType' => '\\StructType\\RatePlanType',
            'RatePlanInclusions' => '\\StructType\\RatePlanInclusions',
            'RateType' => '\\StructType\\RateType',
            'RateUploadType' => '\\StructType\\RateUploadType',
            'BaseByGuestAmts' => '\\StructType\\BaseByGuestAmts',
            'BaseByGuestAmt' => '\\StructType\\BaseByGuestAmt',
            'AdditionalGuestAmount' => '\\StructType\\AdditionalGuestAmount',
            'GuaranteePolicies' => '\\StructType\\GuaranteePolicies',
            'RequiredPaymentLiteType' => '\\StructType\\RequiredPaymentLiteType',
            'RequiredPaymentsType' => '\\StructType\\RequiredPaymentsType',
            'AmountPercent' => '\\StructType\\AmountPercent',
            'RFP_ResponseDetailType' => '\\StructType\\RFP_ResponseDetailType',
            'RoomRateLiteType' => '\\StructType\\RoomRateLiteType',
            'RoomRateType' => '\\StructType\\RoomRateType',
            'Features' => '\\StructType\\Features',
            'Availability' => '\\StructType\\Availability',
            'RoomStayLiteType' => '\\StructType\\RoomStayLiteType',
            'RoomRates' => '\\StructType\\RoomRates',
            'BasicPropertyInfo' => '\\StructType\\BasicPropertyInfo',
            'RoomSharesType' => '\\StructType\\RoomSharesType',
            'RoomShare' => '\\StructType\\RoomShare',
            'GuestRPHs' => '\\StructType\\GuestRPHs',
            'GuestRPH' => '\\StructType\\GuestRPH',
            'RoomStayCandidateType' => '\\StructType\\RoomStayCandidateType',
            'RoomStayType' => '\\StructType\\RoomStayType',
            'RoomRate' => '\\StructType\\RoomRate',
            'AdvanceBookingRestriction' => '\\StructType\\AdvanceBookingRestriction',
            'Restrictions' => '\\StructType\\Restrictions',
            'Restriction' => '\\StructType\\Restriction',
            'GuestCounts' => '\\StructType\\GuestCounts',
            'MapURL' => '\\StructType\\MapURL',
            'RoomTypeLiteType' => '\\StructType\\RoomTypeLiteType',
            'RoomTypeType' => '\\StructType\\RoomTypeType',
            'RoutingHopType' => '\\StructType\\RoutingHopType',
            'RoutingHop' => '\\StructType\\RoutingHop',
            'SellableProductsType' => '\\StructType\\SellableProductsType',
            'SellableProduct' => '\\StructType\\SellableProduct',
            'DestinationSystemCodes' => '\\StructType\\DestinationSystemCodes',
            'InventoryBlock' => '\\StructType\\InventoryBlock',
            'StatisticApplicationSetType' => '\\StructType\\StatisticApplicationSetType',
            'StatisticCodes' => '\\StructType\\StatisticCodes',
            'StatisticCode' => '\\StructType\\StatisticCode',
            'RevenueCategorySummaries' => '\\StructType\\RevenueCategorySummaries',
            'RevenueCategorySummary' => '\\StructType\\RevenueCategorySummary',
            'CountCategorySummaries' => '\\StructType\\CountCategorySummaries',
            'CountCategorySummary' => '\\StructType\\CountCategorySummary',
            'ReportSummaries' => '\\StructType\\ReportSummaries',
            'StatisticType' => '\\StructType\\StatisticType',
            'StatisticApplicationSets' => '\\StructType\\StatisticApplicationSets',
            'StatisticsType' => '\\StructType\\StatisticsType',
            'StatusApplicationControlType' => '\\StructType\\StatusApplicationControlType',
            'ViewershipsType' => '\\StructType\\ViewershipsType',
            'Viewership' => '\\StructType\\Viewership',
            'ViewershipCodes' => '\\StructType\\ViewershipCodes',
            'SystemCodes' => '\\StructType\\SystemCodes',
            'SystemCode' => '\\StructType\\SystemCode',
            'ProfileTypes' => '\\StructType\\ProfileTypes',
            'ProfileRefs' => '\\StructType\\ProfileRefs',
            'Profiles' => '\\StructType\\Profiles',
            'LocationCodes' => '\\StructType\\LocationCodes',
            'LocationCode' => '\\StructType\\LocationCode',
            'BookingChannelCodes' => '\\StructType\\BookingChannelCodes',
            'BookingChannelCode' => '\\StructType\\BookingChannelCode',
            'DistributorTypes' => '\\StructType\\DistributorTypes',
            'DistributorType' => '\\StructType\\DistributorType',
            'WeatherInfoType' => '\\StructType\\WeatherInfoType',
            'Precipitation' => '\\StructType\\Precipitation',
            'Temperature' => '\\StructType\\Temperature',
            'OTA_HotelAvailRQ' => '\\StructType\\OTA_HotelAvailRQ',
            'AvailRequestSegments' => '\\StructType\\AvailRequestSegments',
            'AvailRequestSegmentsType' => '\\StructType\\AvailRequestSegmentsType',
            'AvailRequestSegment' => '\\StructType\\AvailRequestSegment',
            'RoomStayCandidate' => '\\StructType\\RoomStayCandidate',
            'HotelSearchCriteria' => '\\StructType\\HotelSearchCriteria',
            'OTA_HotelAvailRS' => '\\StructType\\OTA_HotelAvailRS',
            'HotelStays' => '\\StructType\\HotelStays',
            'HotelStay' => '\\StructType\\HotelStay',
            'Criteria' => '\\StructType\\Criteria',
            'CurrencyConversions' => '\\StructType\\CurrencyConversions',
            'CurrencyConversion' => '\\StructType\\CurrencyConversion',
            'SellableProducts' => '\\StructType\\SellableProducts',
        );
    }
}
