<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Ricerca ServiceType
 */
$ricerca = new \ServiceType\Ricerca($options);
/**
 * Sample call for RicercaPosizioniPerCodiceFiscalePartitaIva operation/method
 */
if ($ricerca->RicercaPosizioniPerCodiceFiscalePartitaIva(new \StructType\RicercaPosizioniPerCodiceFiscalePartitaIva()) !== false) {
    print_r($ricerca->getResult());
} else {
    print_r($ricerca->getLastError());
}
/**
 * Sample call for RicercaPosizionePerIdentificavo operation/method
 */
if ($ricerca->RicercaPosizionePerIdentificavo(new \StructType\RicercaPosizionePerIdentificavo()) !== false) {
    print_r($ricerca->getResult());
} else {
    print_r($ricerca->getLastError());
}
/**
 * Sample call for RicercaArricchitaPosizionePerIdentificavo operation/method
 */
if ($ricerca->RicercaArricchitaPosizionePerIdentificavo(new \StructType\RicercaArricchitaPosizionePerIdentificavo()) !== false) {
    print_r($ricerca->getResult());
} else {
    print_r($ricerca->getLastError());
}
/**
 * Sample call for RicercaPagamentiGiornalieri operation/method
 */
if ($ricerca->RicercaPagamentiGiornalieri(new \StructType\RicercaPagamentiGiornalieri()) !== false) {
    print_r($ricerca->getResult());
} else {
    print_r($ricerca->getLastError());
}
