<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Debitore StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Debitore
 * @subpackage Structs
 */
class Debitore extends AbstractStructBase
{
    /**
     * The Civico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Civico;
    /**
     * The CodiceAvviamentoPostale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceAvviamentoPostale;
    /**
     * The CodiceFiscalePartitaIva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceFiscalePartitaIva;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Indirizzo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Indirizzo;
    /**
     * The Localita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Localita;
    /**
     * The Nominativo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nominativo;
    /**
     * The Provincia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provincia;
    /**
     * The TipoPagatore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoPagatore;
    /**
     * Constructor method for Debitore
     * @uses Debitore::setCivico()
     * @uses Debitore::setCodiceAvviamentoPostale()
     * @uses Debitore::setCodiceFiscalePartitaIva()
     * @uses Debitore::setEmail()
     * @uses Debitore::setIndirizzo()
     * @uses Debitore::setLocalita()
     * @uses Debitore::setNominativo()
     * @uses Debitore::setProvincia()
     * @uses Debitore::setTipoPagatore()
     * @param string $civico
     * @param string $codiceAvviamentoPostale
     * @param string $codiceFiscalePartitaIva
     * @param string $email
     * @param string $indirizzo
     * @param string $localita
     * @param string $nominativo
     * @param string $provincia
     * @param string $tipoPagatore
     */
    public function __construct($civico = null, $codiceAvviamentoPostale = null, $codiceFiscalePartitaIva = null, $email = null, $indirizzo = null, $localita = null, $nominativo = null, $provincia = null, $tipoPagatore = null)
    {
        $this
            ->setCivico($civico)
            ->setCodiceAvviamentoPostale($codiceAvviamentoPostale)
            ->setCodiceFiscalePartitaIva($codiceFiscalePartitaIva)
            ->setEmail($email)
            ->setIndirizzo($indirizzo)
            ->setLocalita($localita)
            ->setNominativo($nominativo)
            ->setProvincia($provincia)
            ->setTipoPagatore($tipoPagatore);
    }
    /**
     * Get Civico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCivico()
    {
        return isset($this->Civico) ? $this->Civico : null;
    }
    /**
     * Set Civico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $civico
     * @return \StructType\Debitore
     */
    public function setCivico($civico = null)
    {
        // validation for constraint: string
        if (!is_null($civico) && !is_string($civico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($civico, true), gettype($civico)), __LINE__);
        }
        if (is_null($civico) || (is_array($civico) && empty($civico))) {
            unset($this->Civico);
        } else {
            $this->Civico = $civico;
        }
        return $this;
    }
    /**
     * Get CodiceAvviamentoPostale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceAvviamentoPostale()
    {
        return isset($this->CodiceAvviamentoPostale) ? $this->CodiceAvviamentoPostale : null;
    }
    /**
     * Set CodiceAvviamentoPostale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceAvviamentoPostale
     * @return \StructType\Debitore
     */
    public function setCodiceAvviamentoPostale($codiceAvviamentoPostale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceAvviamentoPostale) && !is_string($codiceAvviamentoPostale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceAvviamentoPostale, true), gettype($codiceAvviamentoPostale)), __LINE__);
        }
        if (is_null($codiceAvviamentoPostale) || (is_array($codiceAvviamentoPostale) && empty($codiceAvviamentoPostale))) {
            unset($this->CodiceAvviamentoPostale);
        } else {
            $this->CodiceAvviamentoPostale = $codiceAvviamentoPostale;
        }
        return $this;
    }
    /**
     * Get CodiceFiscalePartitaIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceFiscalePartitaIva()
    {
        return isset($this->CodiceFiscalePartitaIva) ? $this->CodiceFiscalePartitaIva : null;
    }
    /**
     * Set CodiceFiscalePartitaIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceFiscalePartitaIva
     * @return \StructType\Debitore
     */
    public function setCodiceFiscalePartitaIva($codiceFiscalePartitaIva = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscalePartitaIva) && !is_string($codiceFiscalePartitaIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscalePartitaIva, true), gettype($codiceFiscalePartitaIva)), __LINE__);
        }
        if (is_null($codiceFiscalePartitaIva) || (is_array($codiceFiscalePartitaIva) && empty($codiceFiscalePartitaIva))) {
            unset($this->CodiceFiscalePartitaIva);
        } else {
            $this->CodiceFiscalePartitaIva = $codiceFiscalePartitaIva;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\Debitore
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Indirizzo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndirizzo()
    {
        return isset($this->Indirizzo) ? $this->Indirizzo : null;
    }
    /**
     * Set Indirizzo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indirizzo
     * @return \StructType\Debitore
     */
    public function setIndirizzo($indirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($indirizzo) && !is_string($indirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indirizzo, true), gettype($indirizzo)), __LINE__);
        }
        if (is_null($indirizzo) || (is_array($indirizzo) && empty($indirizzo))) {
            unset($this->Indirizzo);
        } else {
            $this->Indirizzo = $indirizzo;
        }
        return $this;
    }
    /**
     * Get Localita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalita()
    {
        return isset($this->Localita) ? $this->Localita : null;
    }
    /**
     * Set Localita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localita
     * @return \StructType\Debitore
     */
    public function setLocalita($localita = null)
    {
        // validation for constraint: string
        if (!is_null($localita) && !is_string($localita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localita, true), gettype($localita)), __LINE__);
        }
        if (is_null($localita) || (is_array($localita) && empty($localita))) {
            unset($this->Localita);
        } else {
            $this->Localita = $localita;
        }
        return $this;
    }
    /**
     * Get Nominativo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNominativo()
    {
        return isset($this->Nominativo) ? $this->Nominativo : null;
    }
    /**
     * Set Nominativo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nominativo
     * @return \StructType\Debitore
     */
    public function setNominativo($nominativo = null)
    {
        // validation for constraint: string
        if (!is_null($nominativo) && !is_string($nominativo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nominativo, true), gettype($nominativo)), __LINE__);
        }
        if (is_null($nominativo) || (is_array($nominativo) && empty($nominativo))) {
            unset($this->Nominativo);
        } else {
            $this->Nominativo = $nominativo;
        }
        return $this;
    }
    /**
     * Get Provincia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvincia()
    {
        return isset($this->Provincia) ? $this->Provincia : null;
    }
    /**
     * Set Provincia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provincia
     * @return \StructType\Debitore
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        if (is_null($provincia) || (is_array($provincia) && empty($provincia))) {
            unset($this->Provincia);
        } else {
            $this->Provincia = $provincia;
        }
        return $this;
    }
    /**
     * Get TipoPagatore value
     * @return string|null
     */
    public function getTipoPagatore()
    {
        return $this->TipoPagatore;
    }
    /**
     * Set TipoPagatore value
     * @uses \EnumType\TipoPagatore::valueIsValid()
     * @uses \EnumType\TipoPagatore::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPagatore
     * @return \StructType\Debitore
     */
    public function setTipoPagatore($tipoPagatore = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoPagatore::valueIsValid($tipoPagatore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoPagatore', is_array($tipoPagatore) ? implode(', ', $tipoPagatore) : var_export($tipoPagatore, true), implode(', ', \EnumType\TipoPagatore::getValidValues())), __LINE__);
        }
        $this->TipoPagatore = $tipoPagatore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Debitore
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
