<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ricerca ServiceType
 * @subpackage Services
 */
class Ricerca extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * RicercaPosizioniPerCodiceFiscalePartitaIva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RicercaPosizioniPerCodiceFiscalePartitaIva $parameters
     * @return \StructType\RicercaPosizioniPerCodiceFiscalePartitaIvaResponse|bool
     */
    public function RicercaPosizioniPerCodiceFiscalePartitaIva(\StructType\RicercaPosizioniPerCodiceFiscalePartitaIva $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RicercaPosizioniPerCodiceFiscalePartitaIva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RicercaPosizionePerIdentificavo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RicercaPosizionePerIdentificavo $parameters
     * @return \StructType\RicercaPosizionePerIdentificavoResponse|bool
     */
    public function RicercaPosizionePerIdentificavo(\StructType\RicercaPosizionePerIdentificavo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RicercaPosizionePerIdentificavo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RicercaArricchitaPosizionePerIdentificavo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RicercaArricchitaPosizionePerIdentificavo $parameters
     * @return \StructType\RicercaArricchitaPosizionePerIdentificavoResponse|bool
     */
    public function RicercaArricchitaPosizionePerIdentificavo(\StructType\RicercaArricchitaPosizionePerIdentificavo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RicercaArricchitaPosizionePerIdentificavo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RicercaPagamentiGiornalieri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RicercaPagamentiGiornalieri $parameters
     * @return \StructType\RicercaPagamentiGiornalieriResponse|bool
     */
    public function RicercaPagamentiGiornalieri(\StructType\RicercaPagamentiGiornalieri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RicercaPagamentiGiornalieri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RicercaArricchitaPosizionePerIdentificavoResponse|\StructType\RicercaPagamentiGiornalieriResponse|\StructType\RicercaPosizionePerIdentificavoResponse|\StructType\RicercaPosizioniPerCodiceFiscalePartitaIvaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
