<?php

namespace EnumType;

/**
 * This class stands for EsitoPagamento EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EsitoPagamento
 * @subpackage Enumerations
 */
class EsitoPagamento
{
    /**
     * Constant for value 'PagamentoEseguito'
     * @return string 'PagamentoEseguito'
     */
    const VALUE_PAGAMENTO_ESEGUITO = 'PagamentoEseguito';
    /**
     * Constant for value 'PagamentoRevocato'
     * @return string 'PagamentoRevocato'
     */
    const VALUE_PAGAMENTO_REVOCATO = 'PagamentoRevocato';
    /**
     * Constant for value 'PagamentoInAassenzaRPT'
     * @return string 'PagamentoInAassenzaRPT'
     */
    const VALUE_PAGAMENTO_IN_AASSENZA_RPT = 'PagamentoInAassenzaRPT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAGAMENTO_ESEGUITO
     * @uses self::VALUE_PAGAMENTO_REVOCATO
     * @uses self::VALUE_PAGAMENTO_IN_AASSENZA_RPT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAGAMENTO_ESEGUITO,
            self::VALUE_PAGAMENTO_REVOCATO,
            self::VALUE_PAGAMENTO_IN_AASSENZA_RPT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
