<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva
 * @subpackage Structs
 */
class RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva extends DeliverAuthenticatedRequestBase
{
    /**
     * The CodiceEnte
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceEnte;
    /**
     * The CodiceFiscale
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceFiscale;
    /**
     * The StatoPosizione
     * @var string
     */
    public $StatoPosizione;
    /**
     * Constructor method for RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva
     * @uses RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva::setCodiceEnte()
     * @uses RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva::setCodiceFiscale()
     * @uses RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva::setStatoPosizione()
     * @param string $codiceEnte
     * @param string $codiceFiscale
     * @param string $statoPosizione
     */
    public function __construct($codiceEnte = null, $codiceFiscale = null, $statoPosizione = null)
    {
        $this
            ->setCodiceEnte($codiceEnte)
            ->setCodiceFiscale($codiceFiscale)
            ->setStatoPosizione($statoPosizione);
    }
    /**
     * Get CodiceEnte value
     * @return string|null
     */
    public function getCodiceEnte()
    {
        return $this->CodiceEnte;
    }
    /**
     * Set CodiceEnte value
     * @param string $codiceEnte
     * @return \StructType\RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva
     */
    public function setCodiceEnte($codiceEnte = null)
    {
        // validation for constraint: string
        if (!is_null($codiceEnte) && !is_string($codiceEnte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceEnte, true), gettype($codiceEnte)), __LINE__);
        }
        $this->CodiceEnte = $codiceEnte;
        return $this;
    }
    /**
     * Get CodiceFiscale value
     * @return string|null
     */
    public function getCodiceFiscale()
    {
        return $this->CodiceFiscale;
    }
    /**
     * Set CodiceFiscale value
     * @param string $codiceFiscale
     * @return \StructType\RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva
     */
    public function setCodiceFiscale($codiceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscale) && !is_string($codiceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscale, true), gettype($codiceFiscale)), __LINE__);
        }
        $this->CodiceFiscale = $codiceFiscale;
        return $this;
    }
    /**
     * Get StatoPosizione value
     * @return string|null
     */
    public function getStatoPosizione()
    {
        return $this->StatoPosizione;
    }
    /**
     * Set StatoPosizione value
     * @uses \EnumType\StatoPosizioneFilter::valueIsValid()
     * @uses \EnumType\StatoPosizioneFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statoPosizione
     * @return \StructType\RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva
     */
    public function setStatoPosizione($statoPosizione = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatoPosizioneFilter::valueIsValid($statoPosizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatoPosizioneFilter', is_array($statoPosizione) ? implode(', ', $statoPosizione) : var_export($statoPosizione, true), implode(', ', \EnumType\StatoPosizioneFilter::getValidValues())), __LINE__);
        }
        $this->StatoPosizione = $statoPosizione;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RichiestaRicercaPosizioniPerCodiceFiscalePartitaIva
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
