<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PosizioneArricchita StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PosizioneArricchita
 * @subpackage Structs
 */
class PosizioneArricchita extends AbstractStructBase
{
    /**
     * The Causale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Causale;
    /**
     * The CodiceRiferimentoCreditore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceRiferimentoCreditore;
    /**
     * The Creditore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Creditore
     */
    public $Creditore;
    /**
     * The DataPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataPagamento;
    /**
     * The DataScadenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataScadenza;
    /**
     * The Debitore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Debitore
     */
    public $Debitore;
    /**
     * The IdentificativoPosizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificativoPosizione;
    /**
     * The ImportoInCentesimi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ImportoInCentesimi;
    /**
     * The NumeroAvviso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroAvviso;
    /**
     * The ParametriPosizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParametroPosizione
     */
    public $ParametriPosizione;
    /**
     * The Servizio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Servizio
     */
    public $Servizio;
    /**
     * The StatoPosizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatoPosizione;
    /**
     * The TipoRiferimentoCreditore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoRiferimentoCreditore;
    /**
     * Constructor method for PosizioneArricchita
     * @uses PosizioneArricchita::setCausale()
     * @uses PosizioneArricchita::setCodiceRiferimentoCreditore()
     * @uses PosizioneArricchita::setCreditore()
     * @uses PosizioneArricchita::setDataPagamento()
     * @uses PosizioneArricchita::setDataScadenza()
     * @uses PosizioneArricchita::setDebitore()
     * @uses PosizioneArricchita::setIdentificativoPosizione()
     * @uses PosizioneArricchita::setImportoInCentesimi()
     * @uses PosizioneArricchita::setNumeroAvviso()
     * @uses PosizioneArricchita::setParametriPosizione()
     * @uses PosizioneArricchita::setServizio()
     * @uses PosizioneArricchita::setStatoPosizione()
     * @uses PosizioneArricchita::setTipoRiferimentoCreditore()
     * @param string $causale
     * @param string $codiceRiferimentoCreditore
     * @param \StructType\Creditore $creditore
     * @param string $dataPagamento
     * @param string $dataScadenza
     * @param \StructType\Debitore $debitore
     * @param string $identificativoPosizione
     * @param int $importoInCentesimi
     * @param string $numeroAvviso
     * @param \ArrayType\ArrayOfParametroPosizione $parametriPosizione
     * @param \StructType\Servizio $servizio
     * @param string $statoPosizione
     * @param string $tipoRiferimentoCreditore
     */
    public function __construct($causale = null, $codiceRiferimentoCreditore = null, \StructType\Creditore $creditore = null, $dataPagamento = null, $dataScadenza = null, \StructType\Debitore $debitore = null, $identificativoPosizione = null, $importoInCentesimi = null, $numeroAvviso = null, \ArrayType\ArrayOfParametroPosizione $parametriPosizione = null, \StructType\Servizio $servizio = null, $statoPosizione = null, $tipoRiferimentoCreditore = null)
    {
        $this
            ->setCausale($causale)
            ->setCodiceRiferimentoCreditore($codiceRiferimentoCreditore)
            ->setCreditore($creditore)
            ->setDataPagamento($dataPagamento)
            ->setDataScadenza($dataScadenza)
            ->setDebitore($debitore)
            ->setIdentificativoPosizione($identificativoPosizione)
            ->setImportoInCentesimi($importoInCentesimi)
            ->setNumeroAvviso($numeroAvviso)
            ->setParametriPosizione($parametriPosizione)
            ->setServizio($servizio)
            ->setStatoPosizione($statoPosizione)
            ->setTipoRiferimentoCreditore($tipoRiferimentoCreditore);
    }
    /**
     * Get Causale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCausale()
    {
        return isset($this->Causale) ? $this->Causale : null;
    }
    /**
     * Set Causale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $causale
     * @return \StructType\PosizioneArricchita
     */
    public function setCausale($causale = null)
    {
        // validation for constraint: string
        if (!is_null($causale) && !is_string($causale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($causale, true), gettype($causale)), __LINE__);
        }
        if (is_null($causale) || (is_array($causale) && empty($causale))) {
            unset($this->Causale);
        } else {
            $this->Causale = $causale;
        }
        return $this;
    }
    /**
     * Get CodiceRiferimentoCreditore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceRiferimentoCreditore()
    {
        return isset($this->CodiceRiferimentoCreditore) ? $this->CodiceRiferimentoCreditore : null;
    }
    /**
     * Set CodiceRiferimentoCreditore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceRiferimentoCreditore
     * @return \StructType\PosizioneArricchita
     */
    public function setCodiceRiferimentoCreditore($codiceRiferimentoCreditore = null)
    {
        // validation for constraint: string
        if (!is_null($codiceRiferimentoCreditore) && !is_string($codiceRiferimentoCreditore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceRiferimentoCreditore, true), gettype($codiceRiferimentoCreditore)), __LINE__);
        }
        if (is_null($codiceRiferimentoCreditore) || (is_array($codiceRiferimentoCreditore) && empty($codiceRiferimentoCreditore))) {
            unset($this->CodiceRiferimentoCreditore);
        } else {
            $this->CodiceRiferimentoCreditore = $codiceRiferimentoCreditore;
        }
        return $this;
    }
    /**
     * Get Creditore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Creditore|null
     */
    public function getCreditore()
    {
        return isset($this->Creditore) ? $this->Creditore : null;
    }
    /**
     * Set Creditore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Creditore $creditore
     * @return \StructType\PosizioneArricchita
     */
    public function setCreditore(\StructType\Creditore $creditore = null)
    {
        if (is_null($creditore) || (is_array($creditore) && empty($creditore))) {
            unset($this->Creditore);
        } else {
            $this->Creditore = $creditore;
        }
        return $this;
    }
    /**
     * Get DataPagamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataPagamento()
    {
        return isset($this->DataPagamento) ? $this->DataPagamento : null;
    }
    /**
     * Set DataPagamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataPagamento
     * @return \StructType\PosizioneArricchita
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataPagamento, true), gettype($dataPagamento)), __LINE__);
        }
        if (is_null($dataPagamento) || (is_array($dataPagamento) && empty($dataPagamento))) {
            unset($this->DataPagamento);
        } else {
            $this->DataPagamento = $dataPagamento;
        }
        return $this;
    }
    /**
     * Get DataScadenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataScadenza()
    {
        return isset($this->DataScadenza) ? $this->DataScadenza : null;
    }
    /**
     * Set DataScadenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataScadenza
     * @return \StructType\PosizioneArricchita
     */
    public function setDataScadenza($dataScadenza = null)
    {
        // validation for constraint: string
        if (!is_null($dataScadenza) && !is_string($dataScadenza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataScadenza, true), gettype($dataScadenza)), __LINE__);
        }
        if (is_null($dataScadenza) || (is_array($dataScadenza) && empty($dataScadenza))) {
            unset($this->DataScadenza);
        } else {
            $this->DataScadenza = $dataScadenza;
        }
        return $this;
    }
    /**
     * Get Debitore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Debitore|null
     */
    public function getDebitore()
    {
        return isset($this->Debitore) ? $this->Debitore : null;
    }
    /**
     * Set Debitore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Debitore $debitore
     * @return \StructType\PosizioneArricchita
     */
    public function setDebitore(\StructType\Debitore $debitore = null)
    {
        if (is_null($debitore) || (is_array($debitore) && empty($debitore))) {
            unset($this->Debitore);
        } else {
            $this->Debitore = $debitore;
        }
        return $this;
    }
    /**
     * Get IdentificativoPosizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificativoPosizione()
    {
        return isset($this->IdentificativoPosizione) ? $this->IdentificativoPosizione : null;
    }
    /**
     * Set IdentificativoPosizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificativoPosizione
     * @return \StructType\PosizioneArricchita
     */
    public function setIdentificativoPosizione($identificativoPosizione = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoPosizione) && !is_string($identificativoPosizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificativoPosizione, true), gettype($identificativoPosizione)), __LINE__);
        }
        if (is_null($identificativoPosizione) || (is_array($identificativoPosizione) && empty($identificativoPosizione))) {
            unset($this->IdentificativoPosizione);
        } else {
            $this->IdentificativoPosizione = $identificativoPosizione;
        }
        return $this;
    }
    /**
     * Get ImportoInCentesimi value
     * @return int|null
     */
    public function getImportoInCentesimi()
    {
        return $this->ImportoInCentesimi;
    }
    /**
     * Set ImportoInCentesimi value
     * @param int $importoInCentesimi
     * @return \StructType\PosizioneArricchita
     */
    public function setImportoInCentesimi($importoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoInCentesimi) && !(is_int($importoInCentesimi) || ctype_digit($importoInCentesimi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($importoInCentesimi, true), gettype($importoInCentesimi)), __LINE__);
        }
        $this->ImportoInCentesimi = $importoInCentesimi;
        return $this;
    }
    /**
     * Get NumeroAvviso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroAvviso()
    {
        return isset($this->NumeroAvviso) ? $this->NumeroAvviso : null;
    }
    /**
     * Set NumeroAvviso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroAvviso
     * @return \StructType\PosizioneArricchita
     */
    public function setNumeroAvviso($numeroAvviso = null)
    {
        // validation for constraint: string
        if (!is_null($numeroAvviso) && !is_string($numeroAvviso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroAvviso, true), gettype($numeroAvviso)), __LINE__);
        }
        if (is_null($numeroAvviso) || (is_array($numeroAvviso) && empty($numeroAvviso))) {
            unset($this->NumeroAvviso);
        } else {
            $this->NumeroAvviso = $numeroAvviso;
        }
        return $this;
    }
    /**
     * Get ParametriPosizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParametroPosizione|null
     */
    public function getParametriPosizione()
    {
        return isset($this->ParametriPosizione) ? $this->ParametriPosizione : null;
    }
    /**
     * Set ParametriPosizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParametroPosizione $parametriPosizione
     * @return \StructType\PosizioneArricchita
     */
    public function setParametriPosizione(\ArrayType\ArrayOfParametroPosizione $parametriPosizione = null)
    {
        if (is_null($parametriPosizione) || (is_array($parametriPosizione) && empty($parametriPosizione))) {
            unset($this->ParametriPosizione);
        } else {
            $this->ParametriPosizione = $parametriPosizione;
        }
        return $this;
    }
    /**
     * Get Servizio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Servizio|null
     */
    public function getServizio()
    {
        return isset($this->Servizio) ? $this->Servizio : null;
    }
    /**
     * Set Servizio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Servizio $servizio
     * @return \StructType\PosizioneArricchita
     */
    public function setServizio(\StructType\Servizio $servizio = null)
    {
        if (is_null($servizio) || (is_array($servizio) && empty($servizio))) {
            unset($this->Servizio);
        } else {
            $this->Servizio = $servizio;
        }
        return $this;
    }
    /**
     * Get StatoPosizione value
     * @return string|null
     */
    public function getStatoPosizione()
    {
        return $this->StatoPosizione;
    }
    /**
     * Set StatoPosizione value
     * @uses \EnumType\StatoPosizione::valueIsValid()
     * @uses \EnumType\StatoPosizione::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statoPosizione
     * @return \StructType\PosizioneArricchita
     */
    public function setStatoPosizione($statoPosizione = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatoPosizione::valueIsValid($statoPosizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatoPosizione', is_array($statoPosizione) ? implode(', ', $statoPosizione) : var_export($statoPosizione, true), implode(', ', \EnumType\StatoPosizione::getValidValues())), __LINE__);
        }
        $this->StatoPosizione = $statoPosizione;
        return $this;
    }
    /**
     * Get TipoRiferimentoCreditore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoRiferimentoCreditore()
    {
        return isset($this->TipoRiferimentoCreditore) ? $this->TipoRiferimentoCreditore : null;
    }
    /**
     * Set TipoRiferimentoCreditore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoRiferimentoCreditore
     * @return \StructType\PosizioneArricchita
     */
    public function setTipoRiferimentoCreditore($tipoRiferimentoCreditore = null)
    {
        // validation for constraint: string
        if (!is_null($tipoRiferimentoCreditore) && !is_string($tipoRiferimentoCreditore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoRiferimentoCreditore, true), gettype($tipoRiferimentoCreditore)), __LINE__);
        }
        if (is_null($tipoRiferimentoCreditore) || (is_array($tipoRiferimentoCreditore) && empty($tipoRiferimentoCreditore))) {
            unset($this->TipoRiferimentoCreditore);
        } else {
            $this->TipoRiferimentoCreditore = $tipoRiferimentoCreditore;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PosizioneArricchita
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
