<?php

namespace EnumType;

/**
 * This class stands for TipoPagatore EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TipoPagatore
 * @subpackage Enumerations
 */
class TipoPagatore
{
    /**
     * Constant for value 'PersonaFisica'
     * @return string 'PersonaFisica'
     */
    const VALUE_PERSONA_FISICA = 'PersonaFisica';
    /**
     * Constant for value 'PersonaGiuridica'
     * @return string 'PersonaGiuridica'
     */
    const VALUE_PERSONA_GIURIDICA = 'PersonaGiuridica';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERSONA_FISICA
     * @uses self::VALUE_PERSONA_GIURIDICA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERSONA_FISICA,
            self::VALUE_PERSONA_GIURIDICA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
