<?php

namespace EnumType;

/**
 * This class stands for StatoPosizioneFilter EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StatoPosizioneFilter
 * @subpackage Enumerations
 */
class StatoPosizioneFilter
{
    /**
     * Constant for value 'NonPagata'
     * @return string 'NonPagata'
     */
    const VALUE_NON_PAGATA = 'NonPagata';
    /**
     * Constant for value 'Pagata'
     * @return string 'Pagata'
     */
    const VALUE_PAGATA = 'Pagata';
    /**
     * Constant for value 'PagataParzialmente'
     * @return string 'PagataParzialmente'
     */
    const VALUE_PAGATA_PARZIALMENTE = 'PagataParzialmente';
    /**
     * Constant for value 'Tutti'
     * @return string 'Tutti'
     */
    const VALUE_TUTTI = 'Tutti';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NON_PAGATA
     * @uses self::VALUE_PAGATA
     * @uses self::VALUE_PAGATA_PARZIALMENTE
     * @uses self::VALUE_TUTTI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NON_PAGATA,
            self::VALUE_PAGATA,
            self::VALUE_PAGATA_PARZIALMENTE,
            self::VALUE_TUTTI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
